/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.util.UUID;
import javax.annotation.Nonnull;

public class UuidCoercing
implements Coercing<UUID, String> {
    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof UUID)) {
            throw new CoercingSerializeException("UUID data fetcher result is not a UUID.");
        }
        return dataFetcherResult.toString();
    }

    @Nonnull
    public UUID parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("UUID input value is not a string.");
        }
        try {
            return UUID.fromString((String)input);
        }
        catch (IllegalArgumentException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public UUID parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("UUID input value is not a string.");
        }
        try {
            return UUID.fromString(((StringValue)input).getValue());
        }
        catch (IllegalArgumentException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

