/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.builder;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.externalApi.graphql.api.builder.GraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.utils.CollectionUtils;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class CatalogGraphQLSchemaBuildingContext
extends GraphQLSchemaBuildingContext {
    @Nonnull
    private final CatalogContract catalog;
    @Nonnull
    private final Set<Locale> supportedLocales;
    @Nonnull
    private final Set<Currency> supportedCurrencies;
    @Nonnull
    private final Set<EntitySchemaContract> entitySchemas;
    @Nonnull
    private final Map<String, GraphQLObjectType> entityTypeToEntityObject;

    public CatalogGraphQLSchemaBuildingContext(@Nonnull GraphQLConfig config, @Nonnull Evita evita, @Nonnull CatalogContract catalog) {
        super(config, evita);
        this.catalog = catalog;
        this.supportedLocales = CollectionUtils.createHashSet((int)10);
        this.supportedCurrencies = CollectionUtils.createHashSet((int)10);
        this.entitySchemas = (Set)evita.queryCatalog(catalog.getName(), session -> {
            Set collections = session.getAllEntityTypes();
            HashSet schemas = CollectionUtils.createHashSet((int)collections.size());
            collections.forEach(c -> {
                SealedEntitySchema entitySchema = (SealedEntitySchema)session.getEntitySchema(c).orElseThrow(() -> new EvitaInternalError("Entity `" + c + "` schema unexpectedly not found!"));
                this.supportedLocales.addAll(entitySchema.getLocales());
                this.supportedCurrencies.addAll(entitySchema.getCurrencies());
                schemas.add(entitySchema);
            });
            return schemas;
        }, new SessionTraits.SessionFlags[0]);
        this.entityTypeToEntityObject = CollectionUtils.createHashMap((int)this.entitySchemas.size());
    }

    @Nonnull
    public CatalogSchemaContract getSchema() {
        return this.catalog.getSchema();
    }

    public void registerEntityObject(@Nonnull String entityType, @Nonnull GraphQLObjectType entityObject) {
        this.registerType((GraphQLType)entityObject);
        this.entityTypeToEntityObject.putIfAbsent(entityType, entityObject);
    }

    @Nonnull
    public CatalogContract getCatalog() {
        return this.catalog;
    }

    @Nonnull
    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Nonnull
    public Set<Currency> getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    @Nonnull
    public Set<EntitySchemaContract> getEntitySchemas() {
        return this.entitySchemas;
    }

    @Nonnull
    public Map<String, GraphQLObjectType> getEntityTypeToEntityObject() {
        return this.entityTypeToEntityObject;
    }
}

