/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GetEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetEntityDataFetcher
implements DataFetcher<DataFetcherResult<EntityClassifier>> {
    private static final Logger log = LoggerFactory.getLogger(GetEntityDataFetcher.class);
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public GetEntityDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<EntityClassifier> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.entitySchema);
        FilterBy filterBy = this.buildFilterBy(arguments);
        Require require = this.buildRequire(environment, arguments);
        Query query = Query.query((Collection)QueryConstraints.collection((String)this.entitySchema.getName()), (FilterBy)filterBy, (Require)require);
        log.debug("Generated evitaDB query for single entity fetch of type `{}` is `{}`.", (Object)this.entitySchema.getName(), (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult();
        evitaSession.queryOne(query, EntityClassifier.class).ifPresent(entity -> resultBuilder.data(entity).localContext((Object)GetEntityDataFetcher.buildResultContext(arguments)));
        return resultBuilder.build();
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<Object> filterConstraints = new LinkedList<Object>();
        if (arguments.primaryKey() != null) {
            filterConstraints.add(QueryConstraints.entityPrimaryKeyInSet((Integer[])new Integer[]{arguments.primaryKey()}));
        }
        filterConstraints.add(QueryConstraints.entityLocaleEquals((Locale)arguments.locale()));
        for (Map.Entry<AttributeSchemaContract, Object> attribute : arguments.uniqueAttributes().entrySet()) {
            filterConstraints.add(QueryConstraints.attributeEquals((String)attribute.getKey().getName(), (Serializable)((Serializable)attribute.getValue())));
        }
        if (arguments.priceInPriceLists() != null) {
            filterConstraints.add(QueryConstraints.priceInPriceLists((String[])arguments.priceInPriceLists()));
        }
        filterConstraints.add(QueryConstraints.priceInCurrency((Currency)arguments.priceInCurrency()));
        if (arguments.priceValidIn() != null) {
            filterConstraints.add(QueryConstraints.priceValidIn((OffsetDateTime)arguments.priceValidIn()));
        } else if (arguments.priceValidInNow()) {
            filterConstraints.add(QueryConstraints.priceValidInNow());
        }
        return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments) {
        EntityFetch entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), arguments.locale(), this.entitySchema).orElse(null);
        return QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{entityFetch});
    }

    @Nonnull
    private static EntityQueryContext buildResultContext(@Nonnull Arguments arguments) {
        return new EntityQueryContext(arguments.locale(), arguments.priceInCurrency(), arguments.priceInPriceLists(), arguments.priceValidIn(), arguments.priceValidInNow());
    }

    private record Arguments(@Nullable Integer primaryKey, @Nullable Locale locale, @Nullable Currency priceInCurrency, @Nullable String[] priceInPriceLists, @Nullable OffsetDateTime priceValidIn, boolean priceValidInNow, @Nonnull Map<AttributeSchemaContract, Object> uniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull EntitySchemaContract entitySchema) {
            HashMap<String, Object> arguments = new HashMap<String, Object>(environment.getArguments());
            Integer primaryKey = (Integer)arguments.remove(GetEntityHeaderDescriptor.PRIMARY_KEY.name());
            Locale locale = (Locale)arguments.remove(GetEntityHeaderDescriptor.LOCALE.name());
            Currency priceInCurrency = (Currency)arguments.remove(GetEntityHeaderDescriptor.PRICE_IN_CURRENCY.name());
            List priceInPriceLists = (List)arguments.remove(GetEntityHeaderDescriptor.PRICE_IN_PRICE_LISTS.name());
            OffsetDateTime priceValidIn = (OffsetDateTime)arguments.remove(GetEntityHeaderDescriptor.PRICE_VALID_IN.name());
            boolean priceValidInNow = Optional.ofNullable(arguments.remove(GetEntityHeaderDescriptor.PRICE_VALID_NOW.name())).orElse(false);
            Map<AttributeSchemaContract, Object> uniqueAttributes = Arguments.extractUniqueAttributesFromArguments(arguments, entitySchema);
            if (primaryKey == null && uniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing entity identifying argument (e.g. primary key or unique attribute).");
            }
            return new Arguments(primaryKey, locale, priceInCurrency, priceInPriceLists != null ? (String[])priceInPriceLists.toArray(String[]::new) : null, priceValidIn, priceValidInNow, uniqueAttributes);
        }

        private static Map<AttributeSchemaContract, Object> extractUniqueAttributesFromArguments(@Nonnull HashMap<String, Object> arguments, @Nonnull EntitySchemaContract entitySchema) {
            HashMap uniqueAttributes = CollectionUtils.createHashMap((int)arguments.size());
            for (Map.Entry<String, Object> argument : arguments.entrySet()) {
                String attributeName = argument.getKey();
                AttributeSchemaContract attributeSchema = entitySchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
                if (attributeSchema == null) continue;
                Assert.isPremiseValid((boolean)attributeSchema.isUnique(), () -> new GraphQLQueryResolvingInternalError("Cannot find entity by non-unique attribute `" + attributeName + "`."));
                Object attributeValue = argument.getValue();
                if (attributeValue == null) continue;
                uniqueAttributes.put(attributeSchema, attributeValue);
            }
            return uniqueAttributes;
        }
    }
}

