/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.filter.FilterGroupBy;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.order.OrderGroupBy;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.EntityGroupFetch;
import io.evitadb.api.query.require.EntityRequire;
import io.evitadb.api.query.require.FacetStatisticsDepth;
import io.evitadb.api.query.require.FacetSummaryOfReference;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ExternalEntityDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.FacetSummaryDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.FacetGroupStatisticsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.FacetStatisticsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FacetSummaryResolver {
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final Map<String, EntitySchemaContract> referencedEntitySchemas;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;

    @Nonnull
    public Collection<RequireConstraint> resolve(@Nonnull SelectionSetAggregator extraResultsSelectionSet, @Nullable Locale desiredLocale) {
        List<SelectedField> facetSummaryFields = extraResultsSelectionSet.getImmediateFields(ExtraResultsDescriptor.FACET_SUMMARY.name());
        if (facetSummaryFields.isEmpty()) {
            return List.of();
        }
        return facetSummaryFields.stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(f.getSelectionSet()).stream()).map(f -> this.resolveFacetSummaryOfReference((SelectedField)f, desiredLocale)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c, c2) -> {
            throw new GraphQLInvalidResponseUsageException("Duplicate facet summaries for single reference.");
        })).values();
    }

    @Nonnull
    private Map.Entry<String, RequireConstraint> resolveFacetSummaryOfReference(@Nonnull SelectedField field, @Nullable Locale desiredLocale) {
        OrderBy orderBy;
        FilterBy filterBy;
        OrderGroupBy orderGroupBy;
        FilterGroupBy filterGroupBy;
        ReferenceSchemaContract referenceSchema = (ReferenceSchemaContract)this.entitySchema.getReferenceByName(field.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Could not find reference `" + field.getName() + "` in `" + this.entitySchema.getName() + "`."));
        String referenceName = referenceSchema.getName();
        FacetStatisticsDepth depth = this.resolveStatisticsDepth(field);
        if (referenceSchema.getReferencedGroupType() != null) {
            Object groupEntityDataLocator = referenceSchema.isReferencedGroupTypeManaged() ? new EntityDataLocator(referenceSchema.getReferencedGroupType()) : new ExternalEntityDataLocator(referenceSchema.getReferencedEntityType());
            filterGroupBy = this.resolveGroupFilterBy(field, (DataLocator)groupEntityDataLocator).orElse(null);
            orderGroupBy = this.resolveGroupOrderBy(field, (DataLocator)groupEntityDataLocator).orElse(null);
        } else {
            filterGroupBy = null;
            orderGroupBy = null;
        }
        List<SelectedField> facetStatisticsFields = SelectionSetAggregator.getImmediateFields(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name(), field.getSelectionSet());
        Assert.isTrue((facetStatisticsFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("There can be only one `" + FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name() + "` field for reference `" + referenceName + "`."));
        Optional facetStatisticsField = facetStatisticsFields.stream().findFirst();
        if (facetStatisticsField.isPresent()) {
            Object facetEntityDataLocator = referenceSchema.isReferencedEntityTypeManaged() ? new EntityDataLocator(referenceSchema.getReferencedEntityType()) : new ExternalEntityDataLocator(referenceSchema.getReferencedEntityType());
            filterBy = this.resolveFacetFilterBy((SelectedField)facetStatisticsField.get(), (DataLocator)facetEntityDataLocator).orElse(null);
            orderBy = this.resolveFacetOrderBy((SelectedField)facetStatisticsField.get(), (DataLocator)facetEntityDataLocator).orElse(null);
        } else {
            filterBy = null;
            orderBy = null;
        }
        EntityFetch facetEntityFetch = this.resolveFacetEntityFetch(field, desiredLocale, referenceName).orElse(null);
        EntityGroupFetch groupEntityFetch = this.resolveGroupEntityFetch(field, desiredLocale, referenceName).orElse(null);
        return new AbstractMap.SimpleEntry<String, FacetSummaryOfReference>(referenceName, QueryConstraints.facetSummaryOfReference((String)referenceName, (FacetStatisticsDepth)depth, (FilterBy)filterBy, (FilterGroupBy)filterGroupBy, (OrderBy)orderBy, (OrderGroupBy)orderGroupBy, (EntityRequire[])new EntityRequire[]{facetEntityFetch, groupEntityFetch}));
    }

    @Nonnull
    private FacetStatisticsDepth resolveStatisticsDepth(@Nonnull SelectedField field) {
        boolean impactNeeded = SelectionSetAggregator.getImmediateFields(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name(), field.getSelectionSet()).stream().anyMatch(f2 -> SelectionSetAggregator.containsImmediate(FacetSummaryDescriptor.FacetStatisticsDescriptor.IMPACT.name(), f2.getSelectionSet()));
        return impactNeeded ? FacetStatisticsDepth.IMPACT : FacetStatisticsDepth.COUNTS;
    }

    @Nonnull
    private Optional<FilterGroupBy> resolveGroupFilterBy(@Nonnull SelectedField field, @Nonnull DataLocator groupEntityDataLocator) {
        return Optional.ofNullable(field.getArguments().get(FacetGroupStatisticsHeaderDescriptor.FILTER_GROUP_BY.name())).map(it -> (FilterGroupBy)this.filterConstraintResolver.resolve(groupEntityDataLocator, FacetGroupStatisticsHeaderDescriptor.FILTER_GROUP_BY.name(), it));
    }

    @Nonnull
    private Optional<OrderGroupBy> resolveGroupOrderBy(@Nonnull SelectedField field, @Nonnull DataLocator groupEntityDataLocator) {
        return Optional.ofNullable(field.getArguments().get(FacetGroupStatisticsHeaderDescriptor.ORDER_GROUP_BY.name())).map(it -> (OrderGroupBy)this.orderConstraintResolver.resolve(groupEntityDataLocator, FacetGroupStatisticsHeaderDescriptor.ORDER_GROUP_BY.name(), it));
    }

    @Nonnull
    private Optional<FilterBy> resolveFacetFilterBy(@Nonnull SelectedField field, @Nonnull DataLocator facetEntityDataLocator) {
        return Optional.ofNullable(field.getArguments().get(FacetStatisticsHeaderDescriptor.FILTER_BY.name())).map(it -> (FilterBy)this.filterConstraintResolver.resolve(facetEntityDataLocator, FacetStatisticsHeaderDescriptor.FILTER_BY.name(), it));
    }

    @Nonnull
    private Optional<OrderBy> resolveFacetOrderBy(@Nonnull SelectedField field, @Nonnull DataLocator facetEntityDataLocator) {
        return Optional.ofNullable(field.getArguments().get(FacetStatisticsHeaderDescriptor.ORDER_BY.name())).map(it -> (OrderBy)this.orderConstraintResolver.resolve(facetEntityDataLocator, FacetStatisticsHeaderDescriptor.ORDER_BY.name(), it));
    }

    @Nonnull
    private Optional<EntityFetch> resolveFacetEntityFetch(@Nonnull SelectedField field, @Nullable Locale desiredLocale, @Nonnull String referenceName) {
        List<SelectedField> facetStatisticsFields = SelectionSetAggregator.getImmediateFields(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name(), field.getSelectionSet());
        Assert.isTrue((facetStatisticsFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("There can be only one `" + FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name() + "` field for reference `" + referenceName + "`."));
        return facetStatisticsFields.stream().findFirst().map(facetStatisticsField -> SelectionSetAggregator.getImmediateFields(FacetSummaryDescriptor.FacetStatisticsDescriptor.FACET_ENTITY.name(), facetStatisticsField.getSelectionSet())).flatMap(facetEntityFields -> {
            Assert.isTrue((facetEntityFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("There can be only one `" + FacetSummaryDescriptor.FacetStatisticsDescriptor.FACET_ENTITY.name() + "` field for reference `" + referenceName + "`."));
            return facetEntityFields.stream().findFirst().flatMap(facetEntityField -> this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(facetEntityField.getSelectionSet()), desiredLocale, this.referencedEntitySchemas.get(referenceName)));
        });
    }

    @Nonnull
    private Optional<EntityGroupFetch> resolveGroupEntityFetch(@Nonnull SelectedField field, @Nullable Locale desiredLocale, @Nonnull String referenceName) {
        List<SelectedField> groupEntityFields = SelectionSetAggregator.getImmediateFields(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.GROUP_ENTITY.name(), field.getSelectionSet());
        Assert.isTrue((groupEntityFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("There can be only one `" + FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.GROUP_ENTITY.name() + "` field for reference `" + referenceName + "`."));
        return groupEntityFields.stream().findFirst().flatMap(groupEntityField -> this.entityFetchRequireResolver.resolveGroupFetch(SelectionSetAggregator.from(groupEntityField.getSelectionSet()), desiredLocale, this.referencedEntitySchemas.get(referenceName)));
    }

    public FacetSummaryResolver(@Nonnull EntitySchemaContract entitySchema, @Nonnull Map<String, EntitySchemaContract> referencedEntitySchemas, @Nonnull EntityFetchRequireResolver entityFetchRequireResolver, @Nonnull FilterConstraintResolver filterConstraintResolver, @Nonnull OrderConstraintResolver orderConstraintResolver) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        if (referencedEntitySchemas == null) {
            throw new NullPointerException("referencedEntitySchemas is marked non-null but is null");
        }
        if (entityFetchRequireResolver == null) {
            throw new NullPointerException("entityFetchRequireResolver is marked non-null but is null");
        }
        if (filterConstraintResolver == null) {
            throw new NullPointerException("filterConstraintResolver is marked non-null but is null");
        }
        if (orderConstraintResolver == null) {
            throw new NullPointerException("orderConstraintResolver is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
        this.referencedEntitySchemas = referencedEntitySchemas;
        this.entityFetchRequireResolver = entityFetchRequireResolver;
        this.filterConstraintResolver = filterConstraintResolver;
        this.orderConstraintResolver = orderConstraintResolver;
    }
}

