/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.model.EndpointDescriptorTransformer;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.graphql.api.builder.BuiltFieldDescriptor;
import io.evitadb.externalApi.graphql.api.builder.FinalGraphQLSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.builder.CatalogGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.CollectionGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.EntityObjectBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.FullResponseObjectBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.LocalMutationAggregateObjectBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.OrderConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.RequireConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.DeleteEntitiesMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GetEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GlobalEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ListEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ListUnknownEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.UnknownEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.UpsertEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.CollectionSizeDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.CollectionsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.GetEntityDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.GetUnknownEntityDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.ListEntitiesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.ListUnknownEntitiesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.QueryEntitiesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.mutatingDataFetcher.DeleteEntitiesMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.mutatingDataFetcher.UpsertEntityMutatingDataFetcher;
import io.evitadb.externalApi.graphql.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.graphql.api.dataType.GraphQLScalars;
import io.evitadb.externalApi.graphql.api.model.EndpointDescriptorToGraphQLFieldTransformer;
import io.evitadb.externalApi.graphql.api.model.ObjectDescriptorToGraphQLEnumTypeTransformer;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CatalogDataApiGraphQLSchemaBuilder
extends FinalGraphQLSchemaBuilder<CatalogGraphQLSchemaBuildingContext> {
    private static final ObjectMapper CDO_OBJECT_MAPPER = new ObjectMapper();
    @Nonnull
    private final GraphQLConstraintSchemaBuildingContext constraintContext;
    @Nonnull
    private final FilterConstraintSchemaBuilder filterConstraintSchemaBuilder;
    @Nonnull
    private final OrderConstraintSchemaBuilder orderConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder mainRequireConstraintSchemaBuilder;
    @Nonnull
    private final EntityObjectBuilder entityObjectBuilder;
    @Nonnull
    private final FullResponseObjectBuilder fullResponseObjectBuilder;
    @Nonnull
    private final LocalMutationAggregateObjectBuilder localMutationAggregateObjectBuilder;

    public CatalogDataApiGraphQLSchemaBuilder(@Nonnull GraphQLConfig config, @Nonnull Evita evita, @Nonnull CatalogContract catalog) {
        super(new CatalogGraphQLSchemaBuildingContext(config, evita, catalog));
        this.constraintContext = new GraphQLConstraintSchemaBuildingContext((CatalogGraphQLSchemaBuildingContext)this.buildingContext);
        this.filterConstraintSchemaBuilder = new FilterConstraintSchemaBuilder(this.constraintContext);
        this.orderConstraintSchemaBuilder = new OrderConstraintSchemaBuilder(this.constraintContext);
        this.mainRequireConstraintSchemaBuilder = RequireConstraintSchemaBuilder.forMainRequire(this.constraintContext, new AtomicReference<FilterConstraintSchemaBuilder>(this.filterConstraintSchemaBuilder));
        this.entityObjectBuilder = new EntityObjectBuilder((CatalogGraphQLSchemaBuildingContext)this.buildingContext, this.constraintContext, this.filterConstraintSchemaBuilder, this.orderConstraintSchemaBuilder, CDO_OBJECT_MAPPER, this.argumentBuilderTransformer, this.interfaceBuilderTransformer, this.objectBuilderTransformer, this.fieldBuilderTransformer);
        this.fullResponseObjectBuilder = new FullResponseObjectBuilder((CatalogGraphQLSchemaBuildingContext)this.buildingContext, this.argumentBuilderTransformer, this.objectBuilderTransformer, this.inputObjectBuilderTransformer, this.fieldBuilderTransformer, this.inputFieldBuilderTransformer, this.constraintContext, this.filterConstraintSchemaBuilder, this.orderConstraintSchemaBuilder);
        this.localMutationAggregateObjectBuilder = new LocalMutationAggregateObjectBuilder((CatalogGraphQLSchemaBuildingContext)this.buildingContext, this.inputObjectBuilderTransformer, this.inputFieldBuilderTransformer);
    }

    @Override
    @Nonnull
    public GraphQLSchema build() {
        this.buildCommonTypes();
        this.buildFields();
        return ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).buildGraphQLSchema();
    }

    private void buildCommonTypes() {
        this.buildLocaleEnum().ifPresent(((CatalogGraphQLSchemaBuildingContext)this.buildingContext)::registerCustomEnumIfAbsent);
        this.buildCurrencyEnum().ifPresent(((CatalogGraphQLSchemaBuildingContext)this.buildingContext)::registerCustomEnumIfAbsent);
        GraphQLEnumType scalarEnum = CatalogDataApiGraphQLSchemaBuilder.buildScalarEnum();
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerType((GraphQLType)scalarEnum);
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerType((GraphQLType)CatalogDataApiGraphQLSchemaBuilder.buildAssociatedDataScalarEnum(scalarEnum));
        this.entityObjectBuilder.buildCommonTypes();
        this.fullResponseObjectBuilder.buildCommonTypes();
        this.localMutationAggregateObjectBuilder.buildCommonTypes();
    }

    private void buildFields() {
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildCollectionsField());
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildGetUnknownEntityField());
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildListUnknownEntityField());
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEntitySchemas().forEach(entitySchema -> {
            CollectionGraphQLSchemaBuildingContext collectionBuildingContext = this.setupForCollection((EntitySchemaContract)entitySchema);
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildGetEntityField(collectionBuildingContext));
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildListEntityField(collectionBuildingContext));
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildQueryEntityField(collectionBuildingContext));
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerQueryField(this.buildCountCollectionField(collectionBuildingContext));
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerMutationField(this.buildUpsertEntityField(collectionBuildingContext));
            ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerMutationField(this.buildDeleteEntitiesField(collectionBuildingContext));
        });
        ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).registerTypes(new HashSet<GraphQLType>(this.constraintContext.getBuiltTypes()));
    }

    @Nonnull
    private CollectionGraphQLSchemaBuildingContext setupForCollection(@Nonnull EntitySchemaContract entitySchema) {
        CollectionGraphQLSchemaBuildingContext collectionBuildingContext = new CollectionGraphQLSchemaBuildingContext((CatalogGraphQLSchemaBuildingContext)this.buildingContext, entitySchema);
        GraphQLInputType filterByInputObject = this.filterConstraintSchemaBuilder.build(collectionBuildingContext.getSchema().getName());
        collectionBuildingContext.setFilterByInputObject(filterByInputObject);
        GraphQLInputType orderByInputObject = this.orderConstraintSchemaBuilder.build(collectionBuildingContext.getSchema().getName());
        collectionBuildingContext.setOrderByInputObject(orderByInputObject);
        if (!entitySchema.getCurrencies().isEmpty() || entitySchema.getReferences().values().stream().anyMatch(ReferenceSchemaContract::isFaceted)) {
            GraphQLInputType requireInputObject = this.mainRequireConstraintSchemaBuilder.build(collectionBuildingContext.getSchema().getName());
            collectionBuildingContext.setRequireInputObject(requireInputObject);
        }
        collectionBuildingContext.registerEntityObject(this.entityObjectBuilder.build(collectionBuildingContext));
        collectionBuildingContext.registerEntityObject(this.entityObjectBuilder.build(collectionBuildingContext, EntityObjectBuilder.EntityObjectVariant.NON_HIERARCHICAL));
        return collectionBuildingContext;
    }

    @Nonnull
    private BuiltFieldDescriptor buildCollectionsField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.COLLECTIONS.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).build(), new ReadDataFetcher(new CollectionsDataFetcher(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nullable
    private BuiltFieldDescriptor buildGetUnknownEntityField() {
        GraphQLFieldDefinition.Builder getUnknownEntityFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.GET_UNKNOWN_ENTITY.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)GlobalEntityDescriptor.THIS.name()));
        List<GlobalAttributeSchemaContract> globalAttributes = ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getCatalog().getSchema().getAttributes().values().stream().filter(GlobalAttributeSchemaContract::isUniqueGlobally).toList();
        if (globalAttributes.isEmpty()) {
            return null;
        }
        globalAttributes.stream().map(as -> GraphQLArgument.newArgument().name(as.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).type(DataTypesConverter.getGraphQLScalarType(as.getPlainType())).description(as.getDescription()).deprecate(as.getDeprecationNotice()).build()).forEach(arg_0 -> ((GraphQLFieldDefinition.Builder)getUnknownEntityFieldBuilder).argument(arg_0));
        boolean localeArgumentNeeded = globalAttributes.stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale);
        if (localeArgumentNeeded) {
            getUnknownEntityFieldBuilder.argument(((GraphQLArgument.Builder)UnknownEntityHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        getUnknownEntityFieldBuilder.argument((GraphQLArgument.Builder)UnknownEntityHeaderDescriptor.JOIN.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        return new BuiltFieldDescriptor(getUnknownEntityFieldBuilder.build(), new ReadDataFetcher(new GetUnknownEntityDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedLocales()), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nullable
    private BuiltFieldDescriptor buildListUnknownEntityField() {
        GraphQLFieldDefinition.Builder listUnknownEntityFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.LIST_UNKNOWN_ENTITY.to((EndpointDescriptorTransformer)this.staticEndpointBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)GlobalEntityDescriptor.THIS.name()))))).argument((GraphQLArgument.Builder)ListUnknownEntitiesHeaderDescriptor.LIMIT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        List<GlobalAttributeSchemaContract> globalAttributes = ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getCatalog().getSchema().getAttributes().values().stream().filter(GlobalAttributeSchemaContract::isUniqueGlobally).toList();
        if (globalAttributes.isEmpty()) {
            return null;
        }
        globalAttributes.stream().map(as -> GraphQLArgument.newArgument().name(as.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull(DataTypesConverter.getGraphQLScalarType(as.getPlainType())))).description(as.getDescription()).deprecate(as.getDeprecationNotice()).build()).forEach(arg_0 -> ((GraphQLFieldDefinition.Builder)listUnknownEntityFieldBuilder).argument(arg_0));
        boolean localeArgumentNeeded = globalAttributes.stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale);
        if (localeArgumentNeeded) {
            listUnknownEntityFieldBuilder.argument(((GraphQLArgument.Builder)ListUnknownEntitiesHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        listUnknownEntityFieldBuilder.argument((GraphQLArgument.Builder)ListUnknownEntitiesHeaderDescriptor.JOIN.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        return new BuiltFieldDescriptor(listUnknownEntityFieldBuilder.build(), new ReadDataFetcher(new ListUnknownEntitiesDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedLocales()), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nonnull
    private BuiltFieldDescriptor buildGetEntityField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLFieldDefinition.Builder singleEntityFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.GET_ENTITY.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).description(CatalogDataApiRootDescriptor.GET_ENTITY.description(new Object[]{entitySchema})).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}))).argument((GraphQLArgument.Builder)GetEntityHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        if (!entitySchema.getLocales().isEmpty()) {
            singleEntityFieldBuilder.argument(((GraphQLArgument.Builder)GetEntityHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        if (!entitySchema.getCurrencies().isEmpty()) {
            singleEntityFieldBuilder.argument(((GraphQLArgument.Builder)GetEntityHeaderDescriptor.PRICE_IN_CURRENCY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()))).argument((GraphQLArgument.Builder)GetEntityHeaderDescriptor.PRICE_IN_PRICE_LISTS.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)GetEntityHeaderDescriptor.PRICE_VALID_IN.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)GetEntityHeaderDescriptor.PRICE_VALID_NOW.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        }
        entitySchema.getAttributes().values().stream().filter(AttributeSchemaContract::isUnique).map(as -> GraphQLArgument.newArgument().name(as.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).type(DataTypesConverter.getGraphQLScalarType(as.getPlainType())).description(as.getDescription()).deprecate(as.getDeprecationNotice()).build()).forEach(arg_0 -> ((GraphQLFieldDefinition.Builder)singleEntityFieldBuilder).argument(arg_0));
        return new BuiltFieldDescriptor(singleEntityFieldBuilder.build(), new ReadDataFetcher(new GetEntityDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), entitySchema), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nonnull
    private BuiltFieldDescriptor buildListEntityField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLFieldDefinition.Builder entityListFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.LIST_ENTITY.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).description(CatalogDataApiRootDescriptor.LIST_ENTITY.description(new Object[]{entitySchema})).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema})))))).argument(((GraphQLArgument.Builder)ListEntitiesHeaderDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getFilterByInputObject())).argument(((GraphQLArgument.Builder)ListEntitiesHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getOrderByInputObject())).argument((GraphQLArgument.Builder)ListEntitiesHeaderDescriptor.OFFSET.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)ListEntitiesHeaderDescriptor.LIMIT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        return new BuiltFieldDescriptor(entityListFieldBuilder.build(), new ReadDataFetcher(new ListEntitiesDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), entitySchema), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nonnull
    private BuiltFieldDescriptor buildQueryEntityField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLObjectType entityFullResponseObject = this.fullResponseObjectBuilder.build(collectionBuildingContext.getSchema());
        GraphQLFieldDefinition.Builder entityQueryFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.QUERY_ENTITY.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).description(CatalogDataApiRootDescriptor.QUERY_ENTITY.description(new Object[]{entitySchema})).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)entityFullResponseObject)).argument(((GraphQLArgument.Builder)QueryEntitiesHeaderDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getFilterByInputObject())).argument(((GraphQLArgument.Builder)QueryEntitiesHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getOrderByInputObject()));
        collectionBuildingContext.getRequireInputObject().ifPresent(requireInputObject -> entityQueryFieldBuilder.argument(((GraphQLArgument.Builder)QueryEntitiesHeaderDescriptor.REQUIRE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(requireInputObject)));
        return new BuiltFieldDescriptor(entityQueryFieldBuilder.build(), new ReadDataFetcher(new QueryEntitiesDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), entitySchema), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nonnull
    private BuiltFieldDescriptor buildCountCollectionField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.COUNT_COLLECTION.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).build(), new ReadDataFetcher(new CollectionSizeDataFetcher(entitySchema), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getTracingContext(), ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getEvitaExecutor().orElse(null)));
    }

    @Nonnull
    private BuiltFieldDescriptor buildUpsertEntityField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLFieldDefinition.Builder upsertEntityFieldBuilder = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.UPSERT_ENTITY.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema})))).argument(((GraphQLArgument.Builder)UpsertEntityHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)(entitySchema.isWithGeneratedPrimaryKey() ? GraphQLScalars.INT : GraphQLNonNull.nonNull((GraphQLType)GraphQLScalars.INT)))).argument((GraphQLArgument.Builder)UpsertEntityHeaderDescriptor.ENTITY_EXISTENCE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        GraphQLInputObjectType localMutationAggregateObject = this.localMutationAggregateObjectBuilder.build(collectionBuildingContext.getSchema());
        if (localMutationAggregateObject != null) {
            upsertEntityFieldBuilder.argument(((GraphQLArgument.Builder)UpsertEntityHeaderDescriptor.MUTATIONS.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)localMutationAggregateObject)))).build();
        }
        return new BuiltFieldDescriptor(upsertEntityFieldBuilder.build(), new UpsertEntityMutatingDataFetcher(CDO_OBJECT_MAPPER, ((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), entitySchema));
    }

    @Nonnull
    private BuiltFieldDescriptor buildDeleteEntitiesField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLFieldDefinition deleteEntityByQueryField = ((GraphQLFieldDefinition.Builder)CatalogDataApiRootDescriptor.DELETE_ENTITY.to((EndpointDescriptorTransformer)new EndpointDescriptorToGraphQLFieldTransformer(this.propertyDataTypeBuilderTransformer, entitySchema))).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema})))))).argument(((GraphQLArgument.Builder)DeleteEntitiesMutationHeaderDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getFilterByInputObject())).argument(((GraphQLArgument.Builder)DeleteEntitiesMutationHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(collectionBuildingContext.getOrderByInputObject())).argument((GraphQLArgument.Builder)DeleteEntitiesMutationHeaderDescriptor.OFFSET.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)DeleteEntitiesMutationHeaderDescriptor.LIMIT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(deleteEntityByQueryField, new DeleteEntitiesMutatingDataFetcher(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSchema(), entitySchema));
    }

    @Nonnull
    private static String transformLocaleToGraphQLEnumString(@Nonnull Locale locale) {
        return locale.toLanguageTag().replace("-", "_");
    }

    @Nonnull
    private Optional<GraphQLEnumType> buildLocaleEnum() {
        if (((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedLocales().isEmpty()) {
            return Optional.empty();
        }
        GraphQLEnumType localeEnum = ((GraphQLEnumType.Builder)CatalogDataApiRootDescriptor.LOCALE_ENUM.to((ObjectDescriptorTransformer)new ObjectDescriptorToGraphQLEnumTypeTransformer(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedLocales().stream().map(locale -> Map.entry(CatalogDataApiGraphQLSchemaBuilder.transformLocaleToGraphQLEnumString(locale), locale)).collect(Collectors.toSet())))).build();
        return Optional.of(localeEnum);
    }

    @Nonnull
    private Optional<GraphQLEnumType> buildCurrencyEnum() {
        if (((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedCurrencies().isEmpty()) {
            return Optional.empty();
        }
        GraphQLEnumType currencyEnum = ((GraphQLEnumType.Builder)CatalogDataApiRootDescriptor.CURRENCY_ENUM.to((ObjectDescriptorTransformer)new ObjectDescriptorToGraphQLEnumTypeTransformer(((CatalogGraphQLSchemaBuildingContext)this.buildingContext).getSupportedCurrencies().stream().map(currency -> Map.entry(currency.toString(), currency)).collect(Collectors.toSet())))).build();
        return Optional.of(currencyEnum);
    }
}

