/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.Assert;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.util.FpKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ObjectCoercing
implements Coercing<Object, Object> {
    public Object serialize(@Nonnull Object input) throws CoercingSerializeException {
        return input;
    }

    @Nonnull
    public Object parseValue(@Nonnull Object input) throws CoercingParseValueException {
        return input;
    }

    @Nonnull
    public Object parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        return this.parseLiteral(input, Collections.emptyMap());
    }

    @Nonnull
    public Object parseLiteral(@Nonnull Object input, Map<String, Object> variables) throws CoercingParseLiteralException {
        if (!(input instanceof Value)) {
            throw new CoercingParseLiteralException("Expected AST type `Value` but was '" + input + "'.");
        }
        if (input instanceof FloatValue) {
            return ((FloatValue)input).getValue();
        }
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        if (input instanceof IntValue) {
            return ((IntValue)input).getValue();
        }
        if (input instanceof BooleanValue) {
            return ((BooleanValue)input).isValue();
        }
        if (input instanceof EnumValue) {
            return ((EnumValue)input).getName();
        }
        if (input instanceof VariableReference) {
            String varName = ((VariableReference)input).getName();
            return variables.get(varName);
        }
        if (input instanceof ArrayValue) {
            List values = ((ArrayValue)input).getValues();
            return values.stream().map(v -> this.parseLiteral(v, variables)).collect(Collectors.toList());
        }
        if (input instanceof ObjectValue) {
            List values = ((ObjectValue)input).getObjectFields();
            LinkedHashMap parsedValues = new LinkedHashMap();
            values.forEach(fld -> {
                Object parsedValue = this.parseLiteral(fld.getValue(), variables);
                parsedValues.put(fld.getName(), parsedValue);
            });
            return parsedValues;
        }
        return Assert.assertShouldNeverHappen((String)"We have covered all Value types", (Object[])new Object[0]);
    }

    @Nonnull
    public Value<?> valueToLiteral(@Nonnull Object input) {
        if (input instanceof String) {
            return new StringValue((String)input);
        }
        if (input instanceof Float) {
            return new FloatValue(BigDecimal.valueOf(((Float)input).floatValue()));
        }
        if (input instanceof Double) {
            return new FloatValue(BigDecimal.valueOf((Double)input));
        }
        if (input instanceof BigDecimal) {
            return new FloatValue((BigDecimal)input);
        }
        if (input instanceof BigInteger) {
            return new IntValue((BigInteger)input);
        }
        if (input instanceof Number) {
            long l = ((Number)input).longValue();
            return new IntValue(BigInteger.valueOf(l));
        }
        if (input instanceof Boolean) {
            return new BooleanValue(((Boolean)input).booleanValue());
        }
        if (FpKit.isIterable((Object)input)) {
            return this.handleIterable(FpKit.toIterable((Object)input));
        }
        if (input instanceof Map) {
            return this.handleMap((Map)input);
        }
        throw new UnsupportedOperationException("The ObjectScalar cant handle values of type `" + input.getClass() + "`.");
    }

    private Value<?> handleMap(Map<?, ?> map) {
        ObjectValue.Builder builder = ObjectValue.newObjectValue();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            Value<?> value = this.valueToLiteral(entry.getValue());
            builder.objectField(ObjectField.newObjectField().name(name).value(value).build());
        }
        return builder.build();
    }

    private Value<?> handleIterable(Iterable<?> input) {
        ArrayList values = new ArrayList();
        for (Object val : input) {
            values.add(this.valueToLiteral(val));
        }
        return ArrayValue.newArrayValue().values(values).build();
    }
}

