/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.schemaApi.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AllEntitySchemasDataFetcher
implements DataFetcher<List<EntitySchemaContract>> {
    @Nullable
    private static AllEntitySchemasDataFetcher INSTANCE;

    @Nonnull
    public static AllEntitySchemasDataFetcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AllEntitySchemasDataFetcher();
        }
        return INSTANCE;
    }

    @Nonnull
    public List<EntitySchemaContract> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        Set allEntityTypes = requestExecutedEvent.measureInternalEvitaDBExecution(() -> ((EvitaSessionContract)evitaSession).getAllEntityTypes());
        return allEntityTypes.stream().map(entityType -> (SealedEntitySchema)requestExecutedEvent.measureInternalEvitaDBExecution(() -> evitaSession.getEntitySchema(entityType)).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Missing entity schema for type `" + entityType + "`."))).map(it -> it).toList();
    }

    private AllEntitySchemasDataFetcher() {
    }
}

