/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.mutatingDataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.Strip;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.DeleteEntitiesMutationHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.WriteDataFetcher;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteEntitiesMutatingDataFetcher
implements DataFetcher<DataFetcherResult<List<SealedEntity>>>,
WriteDataFetcher {
    private static final Logger log = LoggerFactory.getLogger(DeleteEntitiesMutatingDataFetcher.class);
    @Nonnull
    private EntitySchemaContract entitySchema;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public DeleteEntitiesMutatingDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        this.filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        this.orderConstraintResolver = new OrderConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(this.filterConstraintResolver));
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(this.filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), this.filterConstraintResolver, this.orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<List<SealedEntity>> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        Arguments arguments = Arguments.from(environment);
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        Query query = requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> {
            FilterBy filterBy = this.buildFilterBy(arguments);
            OrderBy orderBy = this.buildOrderBy(arguments);
            Require require = this.buildRequire(environment, arguments, filterBy);
            return Query.query((Collection)QueryConstraints.collection((String)this.entitySchema.getName()), (FilterBy)filterBy, (OrderBy)orderBy, (Require)require);
        });
        log.debug("Generated evitaDB query for entity deletion of type `{}` is `{}`.", (Object)this.entitySchema.getName(), (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        SealedEntity[] deletedEntities = requestExecutedEvent.measureInternalEvitaDBExecution(() -> evitaSession.deleteSealedEntitiesAndReturnBodies(query));
        return DataFetcherResult.newResult().data(Arrays.asList(deletedEntities)).localContext((Object)EntityQueryContext.empty()).build();
    }

    @Nullable
    private FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        if (arguments.filterBy() == null) {
            return null;
        }
        return (FilterBy)this.filterConstraintResolver.resolve(this.entitySchema.getName(), DeleteEntitiesMutationHeaderDescriptor.FILTER_BY.name(), arguments.filterBy());
    }

    @Nullable
    private OrderBy buildOrderBy(Arguments arguments) {
        if (arguments.orderBy() == null) {
            return null;
        }
        return (OrderBy)this.orderConstraintResolver.resolve(this.entitySchema.getName(), DeleteEntitiesMutationHeaderDescriptor.ORDER_BY.name(), arguments.orderBy());
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments, @Nullable FilterBy filterBy) {
        LinkedList<Strip> requireConstraints = new LinkedList<Strip>();
        Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), DeleteEntitiesMutatingDataFetcher.extractDesiredLocale(filterBy), this.entitySchema);
        entityFetch.ifPresentOrElse(requireConstraints::add, () -> requireConstraints.add((Strip)QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0])));
        if (arguments.offset() != null && arguments.limit() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)arguments.offset(), (Integer)arguments.limit()));
        } else if (arguments.offset() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)arguments.offset(), (Integer)20));
        } else if (arguments.limit() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)0, (Integer)arguments.limit()));
        }
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    @Nullable
    private static Locale extractDesiredLocale(@Nullable FilterBy filterBy) {
        return Optional.ofNullable(filterBy).map(it -> (EntityLocaleEquals)QueryUtils.findConstraint((Constraint)it, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
    }

    public DeleteEntitiesMutatingDataFetcher(@Nonnull EntitySchemaContract entitySchema, @Nonnull FilterConstraintResolver filterConstraintResolver, @Nonnull OrderConstraintResolver orderConstraintResolver, @Nonnull EntityFetchRequireResolver entityFetchRequireResolver) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        if (filterConstraintResolver == null) {
            throw new NullPointerException("filterConstraintResolver is marked non-null but is null");
        }
        if (orderConstraintResolver == null) {
            throw new NullPointerException("orderConstraintResolver is marked non-null but is null");
        }
        if (entityFetchRequireResolver == null) {
            throw new NullPointerException("entityFetchRequireResolver is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
        this.filterConstraintResolver = filterConstraintResolver;
        this.orderConstraintResolver = orderConstraintResolver;
        this.entityFetchRequireResolver = entityFetchRequireResolver;
    }

    private record Arguments(@Nullable Object filterBy, @Nullable Object orderBy, @Nullable Integer offset, @Nullable Integer limit) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment) {
            Object filterBy = environment.getArgument(DeleteEntitiesMutationHeaderDescriptor.FILTER_BY.name());
            Object orderBy = environment.getArgument(DeleteEntitiesMutationHeaderDescriptor.ORDER_BY.name());
            Integer offset = (Integer)environment.getArgument(DeleteEntitiesMutationHeaderDescriptor.OFFSET.name());
            Integer limit = (Integer)environment.getArgument(DeleteEntitiesMutationHeaderDescriptor.LIMIT.name());
            return new Arguments(filterBy, orderBy, offset, limit);
        }
    }
}

