/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.AssociatedDataContent;
import io.evitadb.api.query.require.AttributeContent;
import io.evitadb.api.query.require.DataInLocales;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.EntityGroupFetch;
import io.evitadb.api.query.require.HierarchyContent;
import io.evitadb.api.query.require.HierarchyStopAt;
import io.evitadb.api.query.require.HierarchyStopAtRequireConstraint;
import io.evitadb.api.query.require.PriceContent;
import io.evitadb.api.query.require.PriceContentMode;
import io.evitadb.api.query.require.ReferenceContent;
import io.evitadb.api.requestResponse.schema.AttributeSchemaProvider;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.HierarchyDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.InlineReferenceDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ManagedEntityTypePointer;
import io.evitadb.externalApi.api.catalog.dataApi.model.AttributesProviderDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GraphQLEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AccompanyingPriceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AssociatedDataFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AttributesFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ParentsFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceForSaleDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ReferenceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityFetchRequireResolver {
    private static final Set<String> PRICE_FOR_SALE_FIELDS = Set.of(GraphQLEntityDescriptor.PRICE_FOR_SALE.name(), GraphQLEntityDescriptor.ALL_PRICES_FOR_SALE.name());
    private static final Set<String> CUSTOM_PRICE_FIELDS = Set.of(GraphQLEntityDescriptor.PRICE.name(), GraphQLEntityDescriptor.PRICES.name());
    @Nonnull
    private final Function<String, EntitySchemaContract> entitySchemaFetcher;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;

    @Nonnull
    public Optional<EntityFetch> resolveEntityFetch(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nonnull CatalogSchemaContract catalogSchemaContract, @Nonnull Set<Locale> allPossibleLocales) {
        return this.resolveContentRequirements(selectionSetAggregator, desiredLocale, catalogSchemaContract, allPossibleLocales).map(it -> QueryConstraints.entityFetch((EntityContentRequire[])((EntityContentRequire[])it.toArray(EntityContentRequire[]::new))));
    }

    @Nonnull
    public Optional<EntityFetch> resolveEntityFetch(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        return this.resolveContentRequirements(selectionSetAggregator, desiredLocale, currentEntitySchema).map(it -> QueryConstraints.entityFetch((EntityContentRequire[])((EntityContentRequire[])it.toArray(EntityContentRequire[]::new))));
    }

    @Nonnull
    public Optional<EntityGroupFetch> resolveGroupFetch(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        return this.resolveContentRequirements(selectionSetAggregator, desiredLocale, currentEntitySchema).map(it -> QueryConstraints.entityGroupFetch((EntityContentRequire[])((EntityContentRequire[])it.toArray(EntityContentRequire[]::new))));
    }

    @Nonnull
    private Optional<List<EntityContentRequire>> resolveContentRequirements(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nonnull CatalogSchemaContract catalogSchemaContract, @Nonnull Set<Locale> allPossibleLocales) {
        if (!EntityFetchRequireResolver.needsEntityBody(selectionSetAggregator)) {
            return Optional.empty();
        }
        LinkedList entityContentRequires = new LinkedList();
        EntityFetchRequireResolver.resolveAttributeContent(selectionSetAggregator, catalogSchemaContract).ifPresent(entityContentRequires::add);
        EntityFetchRequireResolver.resolveDataInLocales(selectionSetAggregator, desiredLocale, allPossibleLocales).ifPresent(entityContentRequires::add);
        return Optional.of(entityContentRequires);
    }

    @Nonnull
    private Optional<List<EntityContentRequire>> resolveContentRequirements(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        if (currentEntitySchema == null) {
            return Optional.empty();
        }
        if (!EntityFetchRequireResolver.needsEntityBody(selectionSetAggregator, currentEntitySchema)) {
            return Optional.empty();
        }
        LinkedList<ReferenceContent> entityContentRequires = new LinkedList<ReferenceContent>();
        this.resolveHierarchyContent(selectionSetAggregator, desiredLocale, currentEntitySchema).ifPresent(entityContentRequires::add);
        EntityFetchRequireResolver.resolveAttributeContent(selectionSetAggregator, currentEntitySchema).ifPresent(entityContentRequires::add);
        EntityFetchRequireResolver.resolveAssociatedDataContent(selectionSetAggregator, currentEntitySchema).ifPresent(entityContentRequires::add);
        EntityFetchRequireResolver.resolvePriceContent(selectionSetAggregator).ifPresent(entityContentRequires::add);
        entityContentRequires.addAll(this.resolveReferenceContent(selectionSetAggregator, desiredLocale, currentEntitySchema));
        EntityFetchRequireResolver.resolveDataInLocales(selectionSetAggregator, desiredLocale, currentEntitySchema.getLocales()).ifPresent(entityContentRequires::add);
        return Optional.of(entityContentRequires);
    }

    private static boolean needsEntityBody(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return EntityFetchRequireResolver.needsVersion(selectionSetAggregator) || EntityFetchRequireResolver.needsLocales(selectionSetAggregator) || EntityFetchRequireResolver.needsAttributes(selectionSetAggregator);
    }

    private static boolean needsEntityBody(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nonnull EntitySchemaContract currentEntitySchema) {
        return EntityFetchRequireResolver.needsVersion(selectionSetAggregator) || EntityFetchRequireResolver.needsScope(selectionSetAggregator) || EntityFetchRequireResolver.needsParent(selectionSetAggregator) || EntityFetchRequireResolver.needsParents(selectionSetAggregator) || EntityFetchRequireResolver.needsLocales(selectionSetAggregator) || EntityFetchRequireResolver.needsAttributes(selectionSetAggregator) || EntityFetchRequireResolver.needsAssociatedData(selectionSetAggregator) || EntityFetchRequireResolver.needsPrices(selectionSetAggregator) || EntityFetchRequireResolver.needsReferences(selectionSetAggregator, currentEntitySchema);
    }

    private static boolean needsVersion(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.VERSION.name());
    }

    private static boolean needsScope(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.SCOPE.name());
    }

    private static boolean needsParent(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.PARENT_PRIMARY_KEY.name());
    }

    private static boolean needsParents(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.PARENTS.name());
    }

    private static boolean needsLocales(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.LOCALES.name()) || selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.ALL_LOCALES.name());
    }

    private static boolean needsAttributes(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(AttributesProviderDescriptor.ATTRIBUTES.name());
    }

    private static boolean needsAssociatedData(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.ASSOCIATED_DATA.name());
    }

    private static boolean needsPrices(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.PRICE.name() + "*") || selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.MULTIPLE_PRICES_FOR_SALE_AVAILABLE.name()) || selectionSetAggregator.containsImmediate(GraphQLEntityDescriptor.ALL_PRICES_FOR_SALE.name());
    }

    private static boolean needsReferences(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nonnull EntitySchemaContract currentEntitySchema) {
        return currentEntitySchema.getReferences().values().stream().map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).anyMatch(selectionSetAggregator::containsImmediate);
    }

    @Nonnull
    private Optional<HierarchyContent> resolveHierarchyContent(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!EntityFetchRequireResolver.needsParents(selectionSetAggregator) && !EntityFetchRequireResolver.needsParent(selectionSetAggregator)) {
            return Optional.empty();
        }
        List<SelectedField> parentsFields = selectionSetAggregator.getImmediateFields(GraphQLEntityDescriptor.PARENTS.name());
        Assert.isTrue((parentsFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Only one `" + GraphQLEntityDescriptor.PARENTS.name() + "` field is supported."));
        return parentsFields.stream().findFirst().map(parentsField -> {
            HierarchyDataLocator hierarchyDataLocator = new HierarchyDataLocator((EntityTypePointer)new ManagedEntityTypePointer(currentEntitySchema.getName()));
            HierarchyStopAt stopAt = Optional.ofNullable(parentsField.getArguments().get(ParentsFieldHeaderDescriptor.STOP_AT.name())).map(arg_0 -> this.lambda$resolveHierarchyContent$8((DataLocator)hierarchyDataLocator, arg_0)).orElse(null);
            EntityFetch entityFetch = this.resolveEntityFetch(SelectionSetAggregator.from(parentsField.getSelectionSet()), desiredLocale, currentEntitySchema).orElse(null);
            return QueryConstraints.hierarchyContent((HierarchyStopAt)stopAt, (EntityFetch)entityFetch);
        }).or(() -> {
            if (!selectionSetAggregator.getImmediateFields(GraphQLEntityDescriptor.PARENT_PRIMARY_KEY.name()).isEmpty()) {
                return Optional.of(QueryConstraints.hierarchyContent((HierarchyStopAt)QueryConstraints.stopAt((HierarchyStopAtRequireConstraint)QueryConstraints.distance((Integer)1))));
            }
            return Optional.empty();
        });
    }

    @Nonnull
    private static Optional<AttributeContent> resolveAttributeContent(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nonnull AttributeSchemaProvider<?> attributeSchemaProvider) {
        if (!EntityFetchRequireResolver.needsAttributes(selectionSetAggregator)) {
            return Optional.empty();
        }
        String[] neededAttributes = (String[])selectionSetAggregator.getImmediateFields(AttributesProviderDescriptor.ATTRIBUTES.name()).stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(f.getSelectionSet()).stream()).map(f -> attributeSchemaProvider.getAttributeByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).filter(Optional::isPresent).map(Optional::get).map(NamedSchemaContract::getName).collect(Collectors.toUnmodifiableSet()).toArray(String[]::new);
        return Optional.of(QueryConstraints.attributeContent((String[])neededAttributes));
    }

    @Nonnull
    private static Optional<AssociatedDataContent> resolveAssociatedDataContent(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!EntityFetchRequireResolver.needsAssociatedData(selectionSetAggregator)) {
            return Optional.empty();
        }
        String[] neededAssociatedData = (String[])selectionSetAggregator.getImmediateFields(GraphQLEntityDescriptor.ASSOCIATED_DATA.name()).stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(f.getSelectionSet()).stream()).map(f -> currentEntitySchema.getAssociatedDataByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).filter(Optional::isPresent).map(Optional::get).map(NamedSchemaContract::getName).collect(Collectors.toUnmodifiableSet()).toArray(String[]::new);
        if (neededAssociatedData.length == 0) {
            return Optional.empty();
        }
        return Optional.of(QueryConstraints.associatedDataContent((String[])neededAssociatedData));
    }

    @Nonnull
    private static Optional<PriceContent> resolvePriceContent(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        if (!EntityFetchRequireResolver.needsPrices(selectionSetAggregator)) {
            return Optional.empty();
        }
        if (EntityFetchRequireResolver.isCustomPriceFieldPresent(selectionSetAggregator) || EntityFetchRequireResolver.isCustomPriceForSaleFieldPresent(selectionSetAggregator)) {
            return Optional.of(QueryConstraints.priceContentAll());
        }
        String[] accompanyingPriceListsToFetch = EntityFetchRequireResolver.resolveAccompanyingPriceLists(selectionSetAggregator);
        return Optional.of(QueryConstraints.priceContent((PriceContentMode)PriceContentMode.RESPECTING_FILTER, (String[])accompanyingPriceListsToFetch));
    }

    private static boolean isCustomPriceFieldPresent(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return !selectionSetAggregator.getImmediateFields(CUSTOM_PRICE_FIELDS).isEmpty();
    }

    private static boolean isCustomPriceForSaleFieldPresent(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return selectionSetAggregator.getImmediateFields(PRICE_FOR_SALE_FIELDS).stream().anyMatch(f -> !f.getArguments().isEmpty());
    }

    @Nonnull
    private static String[] resolveAccompanyingPriceLists(@Nonnull SelectionSetAggregator selectionSetAggregator) {
        return (String[])selectionSetAggregator.getImmediateFields(PRICE_FOR_SALE_FIELDS).stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(PriceForSaleDescriptor.ACCOMPANYING_PRICE.name(), f.getSelectionSet()).stream().flatMap(apf -> ((List)apf.getArguments().get(AccompanyingPriceFieldHeaderDescriptor.PRICE_LISTS.name())).stream())).toArray(String[]::new);
    }

    @Nonnull
    private List<ReferenceContent> resolveReferenceContent(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!EntityFetchRequireResolver.needsReferences(selectionSetAggregator, currentEntitySchema)) {
            return List.of();
        }
        return currentEntitySchema.getReferences().values().stream().map(it -> new FieldsForReferenceHolder((ReferenceSchemaContract)it, selectionSetAggregator.getImmediateFields(it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)))).filter(it -> !it.fields().isEmpty()).map(it -> new RequirementForReferenceHolder(it.referenceSchema(), this.resolveReferenceContentFilter(currentEntitySchema, (FieldsForReferenceHolder)it).orElse(null), this.resolveReferenceContentOrder(currentEntitySchema, (FieldsForReferenceHolder)it).orElse(null), EntityFetchRequireResolver.resolveReferenceAttributeContent(it).orElse(null), this.resolveReferenceEntityRequirement(desiredLocale, (FieldsForReferenceHolder)it).orElse(null), this.resolveReferenceGroupRequirement(desiredLocale, (FieldsForReferenceHolder)it).orElse(null))).map(it -> {
            if (it.attributeContent() != null) {
                return QueryConstraints.referenceContentWithAttributes((String)it.referenceSchema().getName(), (FilterBy)it.filterBy(), (OrderBy)it.orderBy(), (AttributeContent)it.attributeContent(), (EntityFetch)it.entityRequirement(), (EntityGroupFetch)it.groupRequirement());
            }
            return QueryConstraints.referenceContent((String)it.referenceSchema().getName(), (FilterBy)it.filterBy(), (OrderBy)it.orderBy(), (EntityFetch)it.entityRequirement(), (EntityGroupFetch)it.groupRequirement());
        }).toList();
    }

    @Nonnull
    private Optional<FilterBy> resolveReferenceContentFilter(@Nonnull EntitySchemaContract currentEntitySchema, @Nonnull FieldsForReferenceHolder fieldsForReferenceHolder) {
        List<SelectedField> fields = fieldsForReferenceHolder.fields();
        boolean someFieldHasFilter = fields.stream().anyMatch(it -> it.getArguments().containsKey(ReferenceFieldHeaderDescriptor.FILTER_BY.name()));
        if (!someFieldHasFilter) {
            return Optional.empty();
        }
        Assert.isTrue((fields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidArgumentException("Reference filtering is currently supported only if there is only one reference of particular name requested."));
        return Optional.ofNullable((FilterBy)this.filterConstraintResolver.resolve((DataLocator)new InlineReferenceDataLocator((EntityTypePointer)new ManagedEntityTypePointer(currentEntitySchema.getName()), fieldsForReferenceHolder.referenceSchema().getName()), ReferenceFieldHeaderDescriptor.FILTER_BY.name(), fields.get(0).getArguments().get(ReferenceFieldHeaderDescriptor.FILTER_BY.name())));
    }

    @Nonnull
    private Optional<OrderBy> resolveReferenceContentOrder(@Nonnull EntitySchemaContract currentEntitySchema, @Nonnull FieldsForReferenceHolder fieldsForReferenceHolder) {
        List<SelectedField> fields = fieldsForReferenceHolder.fields();
        boolean someFieldHasFilter = fields.stream().anyMatch(it -> it.getArguments().containsKey(ReferenceFieldHeaderDescriptor.ORDER_BY.name()));
        if (!someFieldHasFilter) {
            return Optional.empty();
        }
        Assert.isTrue((fields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidArgumentException("Reference ordering is currently supported only if there is only one reference of particular name requested."));
        return Optional.ofNullable((OrderBy)this.orderConstraintResolver.resolve((DataLocator)new InlineReferenceDataLocator((EntityTypePointer)new ManagedEntityTypePointer(currentEntitySchema.getName()), fieldsForReferenceHolder.referenceSchema().getName()), ReferenceFieldHeaderDescriptor.ORDER_BY.name(), fieldsForReferenceHolder.fields().get(0).getArguments().get(ReferenceFieldHeaderDescriptor.ORDER_BY.name())));
    }

    @Nonnull
    private static Optional<AttributeContent> resolveReferenceAttributeContent(@Nonnull FieldsForReferenceHolder fieldsForReferenceHolder) {
        List<DataFetchingFieldSelectionSet> attributeFields = fieldsForReferenceHolder.fields().stream().flatMap(it -> SelectionSetAggregator.getImmediateFields(ReferenceDescriptor.ATTRIBUTES.name(), it.getSelectionSet()).stream()).map(SelectedField::getSelectionSet).toList();
        if (attributeFields.isEmpty()) {
            return Optional.empty();
        }
        String[] neededAttributes = (String[])SelectionSetAggregator.getImmediateFields(attributeFields).stream().map(f -> fieldsForReferenceHolder.referenceSchema().getAttributeByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).filter(Optional::isPresent).map(Optional::get).map(NamedSchemaContract::getName).collect(Collectors.toUnmodifiableSet()).toArray(String[]::new);
        return Optional.of(QueryConstraints.attributeContent((String[])neededAttributes));
    }

    @Nonnull
    private Optional<EntityFetch> resolveReferenceEntityRequirement(@Nullable Locale desiredLocale, @Nonnull FieldsForReferenceHolder fieldsForReference) {
        EntitySchemaContract referencedEntitySchema;
        SelectionSetAggregator referencedEntitySelectionSet = SelectionSetAggregator.from(fieldsForReference.fields().stream().flatMap(it2 -> SelectionSetAggregator.getImmediateFields(ReferenceDescriptor.REFERENCED_ENTITY.name(), it2.getSelectionSet()).stream()).map(SelectedField::getSelectionSet).toList());
        Optional<EntityFetch> referencedEntityRequirement = this.resolveEntityFetch(referencedEntitySelectionSet, desiredLocale, referencedEntitySchema = fieldsForReference.referenceSchema().isReferencedEntityTypeManaged() ? this.entitySchemaFetcher.apply(fieldsForReference.referenceSchema().getReferencedEntityType()) : null);
        if (referencedEntityRequirement.isEmpty() && !referencedEntitySelectionSet.isEmpty()) {
            return Optional.of(QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0]));
        }
        return referencedEntityRequirement;
    }

    @Nonnull
    private Optional<EntityGroupFetch> resolveReferenceGroupRequirement(@Nullable Locale desiredLocale, @Nonnull FieldsForReferenceHolder fieldsForReference) {
        SelectionSetAggregator referencedGroupSelectionSet = SelectionSetAggregator.from(fieldsForReference.fields().stream().flatMap(it2 -> SelectionSetAggregator.getImmediateFields(ReferenceDescriptor.GROUP_ENTITY.name(), it2.getSelectionSet()).stream()).map(SelectedField::getSelectionSet).toList());
        EntitySchemaContract referencedEntitySchema = fieldsForReference.referenceSchema().isReferencedGroupTypeManaged() ? this.entitySchemaFetcher.apply(fieldsForReference.referenceSchema().getReferencedGroupType()) : null;
        return this.resolveGroupFetch(referencedGroupSelectionSet, desiredLocale, referencedEntitySchema);
    }

    @Nonnull
    private static Optional<DataInLocales> resolveDataInLocales(@Nonnull SelectionSetAggregator selectionSetAggregator, @Nullable Locale desiredLocale, @Nonnull Set<Locale> allPossibleLocales) {
        if (!EntityFetchRequireResolver.needsAttributes(selectionSetAggregator) && !EntityFetchRequireResolver.needsAssociatedData(selectionSetAggregator)) {
            return Optional.empty();
        }
        HashSet neededLocales = CollectionUtils.createHashSet((int)allPossibleLocales.size());
        if (desiredLocale != null) {
            neededLocales.add(desiredLocale);
        }
        neededLocales.addAll(selectionSetAggregator.getImmediateFields(GraphQLEntityDescriptor.ATTRIBUTES.name()).stream().map(f -> (Locale)f.getArguments().get(AttributesFieldHeaderDescriptor.LOCALE.name())).filter(Objects::nonNull).collect(Collectors.toSet()));
        neededLocales.addAll(selectionSetAggregator.getImmediateFields(GraphQLEntityDescriptor.ASSOCIATED_DATA.name()).stream().map(f -> (Locale)f.getArguments().get(AssociatedDataFieldHeaderDescriptor.LOCALE.name())).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (neededLocales.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(QueryConstraints.dataInLocales((Locale[])((Locale[])neededLocales.toArray(Locale[]::new))));
    }

    public EntityFetchRequireResolver(@Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull FilterConstraintResolver filterConstraintResolver, @Nonnull OrderConstraintResolver orderConstraintResolver, @Nonnull RequireConstraintResolver requireConstraintResolver) {
        if (entitySchemaFetcher == null) {
            throw new NullPointerException("entitySchemaFetcher is marked non-null but is null");
        }
        if (filterConstraintResolver == null) {
            throw new NullPointerException("filterConstraintResolver is marked non-null but is null");
        }
        if (orderConstraintResolver == null) {
            throw new NullPointerException("orderConstraintResolver is marked non-null but is null");
        }
        if (requireConstraintResolver == null) {
            throw new NullPointerException("requireConstraintResolver is marked non-null but is null");
        }
        this.entitySchemaFetcher = entitySchemaFetcher;
        this.filterConstraintResolver = filterConstraintResolver;
        this.orderConstraintResolver = orderConstraintResolver;
        this.requireConstraintResolver = requireConstraintResolver;
    }

    private /* synthetic */ HierarchyStopAt lambda$resolveHierarchyContent$8(DataLocator hierarchyDataLocator, Object it) {
        return (HierarchyStopAt)this.requireConstraintResolver.resolve(hierarchyDataLocator, hierarchyDataLocator, ParentsFieldHeaderDescriptor.STOP_AT.name(), it);
    }

    private record FieldsForReferenceHolder(@Nonnull ReferenceSchemaContract referenceSchema, @Nonnull List<SelectedField> fields) {
    }

    private record RequirementForReferenceHolder(@Nonnull ReferenceSchemaContract referenceSchema, @Nullable FilterBy filterBy, @Nullable OrderBy orderBy, @Nullable AttributeContent attributeContent, @Nullable EntityFetch entityRequirement, @Nullable EntityGroupFetch groupRequirement) {
    }
}

