/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.schemaApi.resolver.mutatingDataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.mutation.LocalEntitySchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutation;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationObjectParser;
import io.evitadb.externalApi.api.catalog.resolver.mutation.MutationResolvingExceptionFactory;
import io.evitadb.externalApi.api.catalog.resolver.mutation.PassThroughMutationObjectParser;
import io.evitadb.externalApi.api.catalog.schemaApi.resolver.mutation.EntitySchemaMutationAggregateConverter;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.resolver.mutation.GraphQLMutationResolvingExceptionFactory;
import io.evitadb.externalApi.graphql.api.catalog.schemaApi.model.UpdateEntitySchemaQueryHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.WriteDataFetcher;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class UpdateEntitySchemaMutatingDataFetcher
implements DataFetcher<EntitySchemaContract>,
WriteDataFetcher {
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final EntitySchemaMutationAggregateConverter mutationAggregateResolver = new EntitySchemaMutationAggregateConverter((MutationObjectParser)new PassThroughMutationObjectParser(), (MutationResolvingExceptionFactory)new GraphQLMutationResolvingExceptionFactory());

    @Nonnull
    public EntitySchemaContract get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        Arguments arguments = Arguments.from(environment);
        ModifyEntitySchemaMutation entitySchemaMutation = requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> {
            LocalEntitySchemaMutation[] schemaMutations = (LocalEntitySchemaMutation[])arguments.mutations().stream().flatMap(m -> this.mutationAggregateResolver.convert(m).stream()).toArray(LocalEntitySchemaMutation[]::new);
            return new ModifyEntitySchemaMutation(this.entitySchema.getName(), schemaMutations);
        });
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        return (EntitySchemaContract)requestExecutedEvent.measureInternalEvitaDBExecution(() -> evitaSession.updateAndFetchEntitySchema(entitySchemaMutation));
    }

    public UpdateEntitySchemaMutatingDataFetcher(@Nonnull EntitySchemaContract entitySchema) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
    }

    private record Arguments(@Nonnull List<Map<String, Object>> mutations) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment) {
            List mutations = (List)environment.getArgumentOrDefault(UpdateEntitySchemaQueryHeaderDescriptor.MUTATIONS.name(), List.of());
            return new Arguments(mutations);
        }
    }
}

