/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.mutatingDataFetcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.data.mutation.EntityMutation;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.UpsertEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.mutation.GraphQLEntityUpsertMutationConverter;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.WriteDataFetcher;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertEntityMutatingDataFetcher
implements DataFetcher<DataFetcherResult<EntityClassifier>>,
WriteDataFetcher {
    private static final Logger log = LoggerFactory.getLogger(UpsertEntityMutatingDataFetcher.class);
    @Nonnull
    private EntitySchemaContract entitySchema;
    @Nonnull
    private final GraphQLEntityUpsertMutationConverter entityUpsertMutationResolver;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public UpsertEntityMutatingDataFetcher(@Nonnull ObjectMapper objectMapper, @Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        this.entityUpsertMutationResolver = new GraphQLEntityUpsertMutationConverter(objectMapper, entitySchema);
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<EntityClassifier> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        Arguments arguments = Arguments.from(environment);
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        EntityMutation entityMutation = (EntityMutation)requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> this.entityUpsertMutationResolver.convert(arguments.primaryKey(), arguments.entityExistence(), arguments.mutations()));
        Object[] contentRequires = requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> this.buildEnrichingRequires(environment));
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        log.debug("Upserting entity `{}` with PK {} and fetching new version with `{}`.", new Object[]{this.entitySchema.getName(), arguments.primaryKey(), Arrays.toString(contentRequires)});
        SealedEntity upsertedEntity = requestExecutedEvent.measureInternalEvitaDBExecution(() -> UpsertEntityMutatingDataFetcher.lambda$get$2(evitaSession, entityMutation, (EntityContentRequire[])contentRequires));
        return DataFetcherResult.newResult().data((Object)upsertedEntity).localContext((Object)EntityQueryContext.empty()).build();
    }

    @Nonnull
    private EntityContentRequire[] buildEnrichingRequires(@Nonnull DataFetchingEnvironment environment) {
        Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), null, this.entitySchema);
        return entityFetch.map(EntityFetch::getRequirements).orElse(new EntityContentRequire[0]);
    }

    public UpsertEntityMutatingDataFetcher(@Nonnull EntitySchemaContract entitySchema, @Nonnull GraphQLEntityUpsertMutationConverter entityUpsertMutationResolver, @Nonnull EntityFetchRequireResolver entityFetchRequireResolver) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        if (entityUpsertMutationResolver == null) {
            throw new NullPointerException("entityUpsertMutationResolver is marked non-null but is null");
        }
        if (entityFetchRequireResolver == null) {
            throw new NullPointerException("entityFetchRequireResolver is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
        this.entityUpsertMutationResolver = entityUpsertMutationResolver;
        this.entityFetchRequireResolver = entityFetchRequireResolver;
    }

    private static /* synthetic */ SealedEntity lambda$get$2(EvitaSessionContract evitaSession, EntityMutation entityMutation, EntityContentRequire[] contentRequires) {
        return evitaSession.upsertAndFetchEntity(entityMutation, contentRequires);
    }

    private record Arguments(@Nullable Integer primaryKey, @Nonnull EntityMutation.EntityExistence entityExistence, @Nonnull List<Map<String, Object>> mutations) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment) {
            Integer primaryKey = (Integer)environment.getArgument(UpsertEntityHeaderDescriptor.PRIMARY_KEY.name());
            EntityMutation.EntityExistence entityExistence = (EntityMutation.EntityExistence)environment.getArgument(UpsertEntityHeaderDescriptor.ENTITY_EXISTENCE.name());
            List mutations = (List)environment.getArgumentOrDefault(UpsertEntityHeaderDescriptor.MUTATIONS.name(), List.of());
            return new Arguments(primaryKey, entityExistence, mutations);
        }
    }
}

