/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponseWriter;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidUsageException;
import io.evitadb.externalApi.graphql.io.GraphQLSchemaEndpointExecutionContext;
import io.evitadb.externalApi.graphql.utils.GraphQLSchemaPrinter;
import io.evitadb.externalApi.http.EndpointHandler;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.netty.channel.EventLoop;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaHandler
extends EndpointHandler<GraphQLSchemaEndpointExecutionContext> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaHandler.class);
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final AtomicReference<GraphQL> graphQL;

    public GraphQLSchemaHandler(@Nonnull Evita evita, @Nonnull AtomicReference<GraphQL> graphQL) {
        this.evita = evita;
        this.graphQL = graphQL;
    }

    @Nonnull
    protected GraphQLSchemaEndpointExecutionContext createExecutionContext(@Nonnull HttpRequest httpRequest) {
        return new GraphQLSchemaEndpointExecutionContext(httpRequest, this.evita);
    }

    @Nonnull
    protected CompletableFuture<EndpointResponse> doHandleRequest(@Nonnull GraphQLSchemaEndpointExecutionContext executionContext) {
        return executionContext.executeAsyncInRequestThreadPool(() -> new SuccessEndpointResponse((Object)this.graphQL.get().getGraphQLSchema()));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message) {
        return (T)((Object)new GraphQLInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        return (T)((Object)new GraphQLInternalError(message, cause));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidUsageException(@Nonnull String message) {
        return (T)((Object)new GraphQLInvalidUsageException(message));
    }

    @Nonnull
    public Set<HttpMethod> getSupportedHttpMethods() {
        return Set.of(HttpMethod.GET);
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        LinkedHashSet mediaTypes = CollectionUtils.createLinkedHashSet((int)1);
        mediaTypes.add("application/graphql");
        return mediaTypes;
    }

    protected void writeResponse(@Nonnull GraphQLSchemaEndpointExecutionContext executionContext, @Nonnull HttpResponseWriter responseWriter, @Nonnull Object response, @Nonnull EventLoop eventExecutors) {
        Assert.isPremiseValid((boolean)(response instanceof GraphQLSchema), () -> new GraphQLInternalError("Expected response to be instance of GraphQLSchema, but was `" + response.getClass().getName() + "`."));
        String printedSchema = GraphQLSchemaPrinter.print((GraphQLSchema)response);
        responseWriter.write((Object)HttpData.ofUtf8((String)printedSchema));
    }
}

