/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.model;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.evitadb.externalApi.api.model.PropertyDataTypeDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptor;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.FieldDecorator;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PropertyDescriptorToGraphQLFieldTransformer
implements PropertyDescriptorTransformer<GraphQLFieldDefinition.Builder> {
    @Nonnull
    private final PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer;
    @Nullable
    private final FieldDecorator fieldDecorator;

    public PropertyDescriptorToGraphQLFieldTransformer(@Nonnull PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer) {
        this(propertyDataTypeTransformer, null);
    }

    public GraphQLFieldDefinition.Builder apply(@Nonnull PropertyDescriptor propertyDescriptor) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(propertyDescriptor.name()).description(propertyDescriptor.description());
        Assert.isPremiseValid((propertyDescriptor.defaultValue() == null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("GraphQL fields do not support default values but property `" + propertyDescriptor.name() + "` has one."));
        if (propertyDescriptor.deprecate() != null) {
            fieldBuilder.deprecate(propertyDescriptor.deprecate());
        }
        if (propertyDescriptor.type() != null) {
            GraphQLOutputType graphQLType = (GraphQLOutputType)this.propertyDataTypeTransformer.apply((Object)propertyDescriptor.type());
            fieldBuilder.type(graphQLType);
        }
        if (this.fieldDecorator != null) {
            this.fieldDecorator.accept(fieldBuilder);
        }
        return fieldBuilder;
    }

    @Nonnull
    public PropertyDescriptorToGraphQLFieldTransformer with(@Nonnull FieldDecorator decorator) {
        return new PropertyDescriptorToGraphQLFieldTransformer(this.propertyDataTypeTransformer, decorator);
    }

    public PropertyDescriptorToGraphQLFieldTransformer(@Nonnull PropertyDataTypeDescriptorTransformer<GraphQLType> propertyDataTypeTransformer, @Nullable FieldDecorator fieldDecorator) {
        if (propertyDataTypeTransformer == null) {
            throw new NullPointerException("propertyDataTypeTransformer is marked non-null but is null");
        }
        this.propertyDataTypeTransformer = propertyDataTypeTransformer;
        this.fieldDecorator = fieldDecorator;
    }
}

