/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.graphql.GraphQLManager;
import io.evitadb.externalApi.graphql.GraphQLProvider;
import io.evitadb.externalApi.graphql.api.catalog.CatalogGraphQLRefreshingObserver;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderRegistrar;
import io.evitadb.externalApi.http.ExternalApiServer;
import javax.annotation.Nonnull;

public class GraphQLProviderRegistrar
implements ExternalApiProviderRegistrar<GraphQLConfig> {
    @Nonnull
    public String getExternalApiCode() {
        return "graphQL";
    }

    @Nonnull
    public Class<GraphQLConfig> getConfigurationClass() {
        return GraphQLConfig.class;
    }

    @Nonnull
    public ExternalApiProvider<GraphQLConfig> register(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull ApiOptions apiOptions, @Nonnull GraphQLConfig graphQLConfig) {
        GraphQLManager graphQLManager = new GraphQLManager(evita, graphQLConfig);
        evita.registerStructuralChangeObserver((CatalogStructuralChangeObserver)new CatalogGraphQLRefreshingObserver(graphQLManager));
        return new GraphQLProvider(graphQLConfig, graphQLManager);
    }
}

