/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import io.evitadb.api.ClientContext;
import io.evitadb.api.query.require.HierarchyStopAt;
import io.evitadb.api.requestResponse.schema.AssociatedDataSchemaContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.Cardinality;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.HierarchyDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ReferenceDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.AssociatedDataDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.AttributesDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.PriceDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.graphql.api.builder.BuiltFieldDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.builder.CatalogGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.CollectionGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.NonNullBigDecimalFieldDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.NullableBigDecimalFieldDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.PriceBigDecimalFieldDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.OrderConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.RequireConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GlobalEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GraphQLEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AssociatedDataFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AttributesFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ParentsFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceForSaleFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PricesFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ReferenceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.BigDecimalDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityDtoTypeResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.AssociatedDataDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.AssociatedDataValueDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.AttributeValueDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.AttributesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.NonHierarchicalParentPrimaryKeyDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ParentPrimaryKeyDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ParentsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.PriceBigDecimalDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.PriceDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.PriceForSaleDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.PricesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ReferenceDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ReferencedEntityDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ReferencedGroupDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.ReferencesDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity.TargetEntityDataFetcher;
import io.evitadb.externalApi.graphql.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.graphql.api.model.ObjectDescriptorToGraphQLInterfaceTransformer;
import io.evitadb.externalApi.graphql.api.model.ObjectDescriptorToGraphQLObjectTransformer;
import io.evitadb.externalApi.graphql.api.model.PropertyDescriptorToGraphQLArgumentTransformer;
import io.evitadb.externalApi.graphql.api.model.PropertyDescriptorToGraphQLFieldTransformer;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityObjectBuilder {
    @Nonnull
    private final CatalogGraphQLSchemaBuildingContext buildingContext;
    @Nonnull
    private final FilterConstraintSchemaBuilder filterConstraintSchemaBuilder;
    @Nonnull
    private final OrderConstraintSchemaBuilder orderConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder hierarchyRequireConstraintSchemaBuilder;
    @Nonnull
    private final ObjectMapper cdoObjectMapper;
    @Nonnull
    private final PropertyDescriptorToGraphQLArgumentTransformer argumentBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToGraphQLInterfaceTransformer interfaceBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToGraphQLObjectTransformer objectBuilderTransformer;
    @Nonnull
    private final PropertyDescriptorToGraphQLFieldTransformer fieldBuilderTransformer;
    @Nonnull
    private final PriceBigDecimalFieldDecorator priceFieldDecorator;

    public EntityObjectBuilder(@Nonnull CatalogGraphQLSchemaBuildingContext buildingContext, @Nonnull GraphQLConstraintSchemaBuildingContext constraintSchemaBuildingContext, @Nonnull FilterConstraintSchemaBuilder filterConstraintSchemaBuilder, @Nonnull OrderConstraintSchemaBuilder orderConstraintSchemaBuilder, @Nonnull ObjectMapper cdoObjectMapper, @Nonnull PropertyDescriptorToGraphQLArgumentTransformer argumentBuilderTransformer, @Nonnull ObjectDescriptorToGraphQLInterfaceTransformer interfaceBuilderTransformer, @Nonnull ObjectDescriptorToGraphQLObjectTransformer objectBuilderTransformer, @Nonnull PropertyDescriptorToGraphQLFieldTransformer fieldBuilderTransformer) {
        this.buildingContext = buildingContext;
        this.filterConstraintSchemaBuilder = filterConstraintSchemaBuilder;
        this.orderConstraintSchemaBuilder = orderConstraintSchemaBuilder;
        this.hierarchyRequireConstraintSchemaBuilder = RequireConstraintSchemaBuilder.forHierarchyRequire(constraintSchemaBuildingContext, new AtomicReference<FilterConstraintSchemaBuilder>(filterConstraintSchemaBuilder));
        this.cdoObjectMapper = cdoObjectMapper;
        this.argumentBuilderTransformer = argumentBuilderTransformer;
        this.interfaceBuilderTransformer = interfaceBuilderTransformer;
        this.objectBuilderTransformer = objectBuilderTransformer;
        this.fieldBuilderTransformer = fieldBuilderTransformer;
        this.priceFieldDecorator = new PriceBigDecimalFieldDecorator(argumentBuilderTransformer);
    }

    public void buildCommonTypes() {
        GraphQLInterfaceType entityClassifier = ((GraphQLInterfaceType.Builder)EntityDescriptor.THIS_CLASSIFIER.to((ObjectDescriptorTransformer)this.interfaceBuilderTransformer)).build();
        this.buildingContext.registerType((GraphQLType)entityClassifier);
        this.buildingContext.registerTypeResolver(entityClassifier, (TypeResolver)new EntityDtoTypeResolver(this.buildingContext.getEntityTypeToEntityObject()));
        this.buildingContext.registerType((GraphQLType)((GraphQLObjectType.Builder)EntityDescriptor.THIS_REFERENCE.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType((GraphQLType)this.buildPriceObject());
        this.buildingContext.registerType((GraphQLType)this.buildGlobal());
    }

    @Nonnull
    public GraphQLObjectType build(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        return this.build(collectionBuildingContext, EntityObjectVariant.DEFAULT);
    }

    @Nonnull
    public GraphQLObjectType build(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull EntityObjectVariant variant) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        ObjectDescriptor entityDescriptor = switch (variant) {
            case EntityObjectVariant.DEFAULT -> GraphQLEntityDescriptor.THIS;
            case EntityObjectVariant.NON_HIERARCHICAL -> GraphQLEntityDescriptor.THIS_NON_HIERARCHICAL;
            default -> throw new GraphQLSchemaBuildingError("Unsupported version `" + variant + "`.");
        };
        String objectName = entityDescriptor.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder entityObjectBuilder = ((GraphQLObjectType.Builder)entityDescriptor.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName).description(entitySchema.getDescription()).withInterface(GraphQLTypeReference.typeRef((String)GraphQLEntityDescriptor.THIS_CLASSIFIER.name()));
        if (!entitySchema.getLocales().isEmpty()) {
            entityObjectBuilder.field((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.LOCALES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer));
            entityObjectBuilder.field((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.ALL_LOCALES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer));
        }
        if (entitySchema.isWithHierarchy() && variant == EntityObjectVariant.DEFAULT) {
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityParentPrimaryKeyField());
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityParentsField(collectionBuildingContext));
        }
        if (!entitySchema.getCurrencies().isEmpty()) {
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityPriceForSaleField());
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityPriceField());
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityPricesField());
            entityObjectBuilder.field((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PRICE_INNER_RECORD_HANDLING.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer));
        }
        if (!entitySchema.getAttributes().isEmpty()) {
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityAttributesField(collectionBuildingContext, variant));
        }
        if (!entitySchema.getAssociatedData().isEmpty()) {
            this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, this.buildEntityAssociatedDataField(collectionBuildingContext, variant));
        }
        if (!entitySchema.getReferences().isEmpty()) {
            List<BuiltFieldDescriptor> referenceFieldDescriptors = this.buildEntityReferenceFields(collectionBuildingContext, variant);
            referenceFieldDescriptors.forEach(referenceFieldDescriptor -> this.buildingContext.registerFieldToObject(objectName, entityObjectBuilder, (BuiltFieldDescriptor)referenceFieldDescriptor));
        }
        return entityObjectBuilder.build();
    }

    @Nonnull
    private GraphQLObjectType buildGlobal() {
        CatalogSchemaContract catalogSchema = this.buildingContext.getSchema();
        GraphQLObjectType.Builder globalEntityObjectBuilder = (GraphQLObjectType.Builder)GlobalEntityDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer);
        if (!this.buildingContext.getSupportedLocales().isEmpty()) {
            globalEntityObjectBuilder.field((GraphQLFieldDefinition.Builder)GlobalEntityDescriptor.LOCALES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer));
            globalEntityObjectBuilder.field((GraphQLFieldDefinition.Builder)GlobalEntityDescriptor.ALL_LOCALES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer));
        }
        if (!catalogSchema.getAttributes().isEmpty()) {
            this.buildingContext.registerFieldToObject(GlobalEntityDescriptor.THIS, globalEntityObjectBuilder, this.buildGlobalEntityAttributesField());
        }
        this.buildingContext.registerDataFetcher(GlobalEntityDescriptor.THIS, GlobalEntityDescriptor.TARGET_ENTITY, new TargetEntityDataFetcher());
        return globalEntityObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityParentPrimaryKeyField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PARENT_PRIMARY_KEY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).build(), new ParentPrimaryKeyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildNonHierarchicalEntityParentPrimaryKeyField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PARENT_PRIMARY_KEY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).build(), new NonHierarchicalParentPrimaryKeyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityParentsField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        HierarchyDataLocator selfHierarchyConstraintDataLocator = new HierarchyDataLocator(entitySchema.getName());
        GraphQLInputType stopAtConstraint = (GraphQLInputType)this.hierarchyRequireConstraintSchemaBuilder.build((DataLocator)selfHierarchyConstraintDataLocator, HierarchyStopAt.class);
        GraphQLFieldDefinition field = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PARENTS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)GraphQLEntityDescriptor.THIS_NON_HIERARCHICAL.name(new NamedSchemaContract[]{entitySchema}))))).argument(((GraphQLArgument.Builder)ParentsFieldHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).build();
        return new BuiltFieldDescriptor(field, new ParentsDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityPriceForSaleField() {
        GraphQLFieldDefinition field = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PRICE_FOR_SALE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).argument((GraphQLArgument.Builder)PriceForSaleFieldHeaderDescriptor.PRICE_LIST.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument(((GraphQLArgument.Builder)PriceForSaleFieldHeaderDescriptor.CURRENCY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()))).argument((GraphQLArgument.Builder)PriceForSaleFieldHeaderDescriptor.VALID_IN.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)PriceForSaleFieldHeaderDescriptor.VALID_NOW.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument(((GraphQLArgument.Builder)PriceForSaleFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name()))).build();
        return new BuiltFieldDescriptor(field, new PriceForSaleDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityPriceField() {
        GraphQLFieldDefinition field = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PRICE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).argument((GraphQLArgument.Builder)PriceFieldHeaderDescriptor.PRICE_LIST.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument(((GraphQLArgument.Builder)PriceFieldHeaderDescriptor.CURRENCY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()))).argument(((GraphQLArgument.Builder)PriceFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name()))).build();
        return new BuiltFieldDescriptor(field, new PriceDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityPricesField() {
        GraphQLFieldDefinition field = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.PRICES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).argument((GraphQLArgument.Builder)PricesFieldHeaderDescriptor.PRICE_LISTS.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument(((GraphQLArgument.Builder)PricesFieldHeaderDescriptor.CURRENCY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()))).argument(((GraphQLArgument.Builder)PricesFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name()))).build();
        return new BuiltFieldDescriptor(field, new PricesDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildGlobalEntityAttributesField() {
        CatalogSchemaContract catalogSchema = this.buildingContext.getSchema();
        GraphQLObjectType attributesObject = this.buildAttributesObject(catalogSchema.getAttributes().values(), AttributesDescriptor.THIS_GLOBAL.name(), false);
        GraphQLFieldDefinition.Builder attributesFieldBuilder = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)attributesObject));
        if (!this.buildingContext.getSupportedLocales().isEmpty()) {
            attributesFieldBuilder.argument(((GraphQLArgument.Builder)AttributesFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        return new BuiltFieldDescriptor(attributesFieldBuilder.build(), new AttributesDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityAttributesField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull EntityObjectVariant version) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLTypeReference attributesObject = switch (version) {
            case EntityObjectVariant.DEFAULT -> this.buildAttributesObject(entitySchema.getAttributes().values(), AttributesDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}), true);
            case EntityObjectVariant.NON_HIERARCHICAL -> GraphQLTypeReference.typeRef((String)AttributesDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
            default -> throw new GraphQLSchemaBuildingError("Unsupported version `" + version + "`.");
        };
        GraphQLFieldDefinition.Builder attributesFieldBuilder = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)attributesObject);
        if (!entitySchema.getLocales().isEmpty()) {
            attributesFieldBuilder.argument(((GraphQLArgument.Builder)AttributesFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        return new BuiltFieldDescriptor(attributesFieldBuilder.build(), new AttributesDataFetcher());
    }

    @Nonnull
    private GraphQLObjectType buildAttributesObject(@Nonnull Collection<? extends AttributeSchemaContract> attributeSchemas, @Nonnull String objectName, boolean attributesCanBeRequired) {
        GraphQLObjectType.Builder attributesBuilder = ((GraphQLObjectType.Builder)AttributesDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        attributeSchemas.forEach(attributeSchema -> this.buildingContext.registerFieldToObject(objectName, attributesBuilder, this.buildAttributeField((AttributeSchemaContract)attributeSchema, attributesCanBeRequired)));
        return attributesBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildAttributeField(@Nonnull AttributeSchemaContract attributeSchema, boolean canBeRequired) {
        Object attributeFieldDataFetcher;
        GraphQLFieldDefinition.Builder attributeFieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(attributeSchema.getDescription()).deprecate(attributeSchema.getDeprecationNotice());
        Class attributeType = attributeSchema.getType();
        if (BigDecimal.class.isAssignableFrom(attributeType)) {
            if (attributeSchema.isNullable() || !canBeRequired) {
                new NullableBigDecimalFieldDecorator(this.argumentBuilderTransformer).accept(attributeFieldBuilder);
            } else {
                new NonNullBigDecimalFieldDecorator(this.argumentBuilderTransformer).accept(attributeFieldBuilder);
            }
            attributeFieldDataFetcher = new BigDecimalDataFetcher(new AttributeValueDataFetcher<BigDecimal>(attributeSchema));
        } else {
            attributeFieldBuilder.type((GraphQLOutputType)DataTypesConverter.getGraphQLScalarType(attributeType, canBeRequired && !attributeSchema.isNullable()));
            attributeFieldDataFetcher = new AttributeValueDataFetcher(attributeSchema);
        }
        return new BuiltFieldDescriptor(attributeFieldBuilder.build(), (DataFetcher<?>)attributeFieldDataFetcher);
    }

    @Nonnull
    private BuiltFieldDescriptor buildEntityAssociatedDataField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull EntityObjectVariant version) {
        EntitySchemaContract entitySchema = collectionBuildingContext.getSchema();
        GraphQLObjectType associatedDataObject = switch (version) {
            case EntityObjectVariant.DEFAULT -> this.buildAssociatedDataObject(collectionBuildingContext);
            case EntityObjectVariant.NON_HIERARCHICAL -> GraphQLTypeReference.typeRef((String)AssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{collectionBuildingContext.getSchema()}));
            default -> throw new GraphQLSchemaBuildingError("Unsupported version `" + version + "`.");
        };
        GraphQLFieldDefinition.Builder associatedDataFieldBuilder = ((GraphQLFieldDefinition.Builder)GraphQLEntityDescriptor.ASSOCIATED_DATA.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)associatedDataObject);
        if (!entitySchema.getLocales().isEmpty()) {
            associatedDataFieldBuilder.argument(((GraphQLArgument.Builder)AssociatedDataFieldHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLTypeReference.typeRef((String)CatalogDataApiRootDescriptor.LOCALE_ENUM.name())));
        }
        return new BuiltFieldDescriptor(associatedDataFieldBuilder.build(), new AssociatedDataDataFetcher());
    }

    @Nonnull
    private GraphQLObjectType buildAssociatedDataObject(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext) {
        String objectName = AssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{collectionBuildingContext.getSchema()});
        GraphQLObjectType.Builder associatedDataBuilder = ((GraphQLObjectType.Builder)AssociatedDataDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        collectionBuildingContext.getSchema().getAssociatedData().values().forEach(associatedDataSchema -> this.buildingContext.registerFieldToObject(objectName, associatedDataBuilder, this.buildSingleAssociatedDataField((AssociatedDataSchemaContract)associatedDataSchema)));
        return associatedDataBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildSingleAssociatedDataField(@Nonnull AssociatedDataSchemaContract associatedDataSchema) {
        ReadDataFetcher associatedDataFieldDataFetcher;
        GraphQLFieldDefinition.Builder associatedDataFieldBuilder = GraphQLFieldDefinition.newFieldDefinition();
        Class associatedDataType = associatedDataSchema.getType();
        if (BigDecimal.class.isAssignableFrom(associatedDataType)) {
            if (associatedDataSchema.isNullable()) {
                new NullableBigDecimalFieldDecorator(this.argumentBuilderTransformer).accept(associatedDataFieldBuilder);
            } else {
                new NonNullBigDecimalFieldDecorator(this.argumentBuilderTransformer).accept(associatedDataFieldBuilder);
            }
            associatedDataFieldDataFetcher = new ReadDataFetcher(new BigDecimalDataFetcher(new AssociatedDataValueDataFetcher<BigDecimal>(this.cdoObjectMapper, associatedDataSchema)), (ClientContext)this.buildingContext.getEvita(), this.buildingContext.getEvitaExecutor().orElse(null));
        } else {
            associatedDataFieldBuilder.type((GraphQLOutputType)DataTypesConverter.getGraphQLScalarType(associatedDataType, !associatedDataSchema.isNullable()));
            associatedDataFieldDataFetcher = new ReadDataFetcher(new AssociatedDataValueDataFetcher(this.cdoObjectMapper, associatedDataSchema), (ClientContext)this.buildingContext.getEvita(), this.buildingContext.getEvitaExecutor().orElse(null));
        }
        associatedDataFieldBuilder.name(associatedDataSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(associatedDataSchema.getDescription()).deprecate(associatedDataSchema.getDeprecationNotice());
        return new BuiltFieldDescriptor(associatedDataFieldBuilder.build(), associatedDataFieldDataFetcher);
    }

    @Nonnull
    private List<BuiltFieldDescriptor> buildEntityReferenceFields(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull EntityObjectVariant version) {
        Collection referenceSchemas = collectionBuildingContext.getSchema().getReferences().values();
        return referenceSchemas.stream().map(referenceSchema -> {
            GraphQLObjectType referenceObject = switch (version) {
                case EntityObjectVariant.DEFAULT -> this.buildReferenceObject(collectionBuildingContext, (ReferenceSchemaContract)referenceSchema);
                case EntityObjectVariant.NON_HIERARCHICAL -> GraphQLTypeReference.typeRef((String)ReferenceDescriptor.THIS.name(new NamedSchemaContract[]{collectionBuildingContext.getSchema(), referenceSchema}));
                default -> throw new GraphQLSchemaBuildingError("Unsupported version `" + version + "`.");
            };
            ReferenceDataLocator referenceDataLocator = new ReferenceDataLocator(collectionBuildingContext.getSchema().getName(), referenceSchema.getName());
            GraphQLInputType referenceFilter = (GraphQLInputType)this.filterConstraintSchemaBuilder.build((DataLocator)referenceDataLocator);
            GraphQLInputType referenceOrder = (GraphQLInputType)this.orderConstraintSchemaBuilder.build((DataLocator)referenceDataLocator);
            GraphQLFieldDefinition.Builder referenceFieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(referenceSchema.getDescription()).deprecate(referenceSchema.getDeprecationNotice()).argument(((GraphQLArgument.Builder)ReferenceFieldHeaderDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(referenceFilter)).argument(((GraphQLArgument.Builder)ReferenceFieldHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(referenceOrder));
            switch (referenceSchema.getCardinality()) {
                case ZERO_OR_ONE: {
                    referenceFieldBuilder.type((GraphQLOutputType)referenceObject);
                    break;
                }
                case EXACTLY_ONE: {
                    referenceFieldBuilder.type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)referenceObject));
                    break;
                }
                case ZERO_OR_MORE: 
                case ONE_OR_MORE: {
                    referenceFieldBuilder.type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)referenceObject))));
                }
            }
            Object referenceDataFetcher = switch (referenceSchema.getCardinality()) {
                default -> throw new IncompatibleClassChangeError();
                case Cardinality.ZERO_OR_ONE, Cardinality.EXACTLY_ONE -> new ReferenceDataFetcher((ReferenceSchemaContract)referenceSchema);
                case Cardinality.ZERO_OR_MORE, Cardinality.ONE_OR_MORE -> new ReferencesDataFetcher((ReferenceSchemaContract)referenceSchema);
            };
            return new BuiltFieldDescriptor(referenceFieldBuilder.build(), (DataFetcher<?>)referenceDataFetcher);
        }).toList();
    }

    @Nonnull
    private GraphQLObjectType buildReferenceObject(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull ReferenceSchemaContract referenceSchema) {
        String referenceObjectName = ReferenceDescriptor.THIS.name(new NamedSchemaContract[]{collectionBuildingContext.getSchema(), referenceSchema});
        GraphQLObjectType.Builder referenceObjectBuilder = ((GraphQLObjectType.Builder)ReferenceDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(referenceObjectName).description(referenceSchema.getDescription());
        this.buildingContext.registerFieldToObject(referenceObjectName, referenceObjectBuilder, this.buildReferenceReferencedEntityField(referenceSchema));
        if (referenceSchema.getReferencedGroupType() != null) {
            this.buildingContext.registerFieldToObject(referenceObjectName, referenceObjectBuilder, this.buildReferenceGroupEntityField(referenceSchema));
        }
        if (!referenceSchema.getAttributes().isEmpty()) {
            this.buildingContext.registerFieldToObject(referenceObjectName, referenceObjectBuilder, this.buildReferenceAttributesField(collectionBuildingContext, referenceSchema));
        }
        return referenceObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildReferenceAttributesField(@Nonnull CollectionGraphQLSchemaBuildingContext collectionBuildingContext, @Nonnull ReferenceSchemaContract referenceSchema) {
        String referenceAttributesObjectName = AttributesDescriptor.THIS.name(new NamedSchemaContract[]{collectionBuildingContext.getSchema(), referenceSchema});
        GraphQLObjectType attributesObject = this.buildAttributesObject(referenceSchema.getAttributes().values(), referenceAttributesObjectName, true);
        GraphQLFieldDefinition attributesField = ((GraphQLFieldDefinition.Builder)ReferenceDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)attributesObject).build();
        return new BuiltFieldDescriptor(attributesField, new AttributesDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildReferenceReferencedEntityField(@Nonnull ReferenceSchemaContract referenceSchema) {
        EntitySchemaContract referencedEntitySchema = referenceSchema.isReferencedEntityTypeManaged() ? this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType()) : null;
        GraphQLOutputType referencedEntityObject = EntityObjectBuilder.buildReferencedEntityObject(referencedEntitySchema);
        GraphQLFieldDefinition referencedEntityField = ((GraphQLFieldDefinition.Builder)ReferenceDescriptor.REFERENCED_ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type(referencedEntityObject).build();
        return new BuiltFieldDescriptor(referencedEntityField, new ReferencedEntityDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildReferenceGroupEntityField(@Nonnull ReferenceSchemaContract referenceSchema) {
        EntitySchemaContract referencedEntitySchema = referenceSchema.isReferencedGroupTypeManaged() ? this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedGroupType()) : null;
        GraphQLOutputType referencedEntityObject = EntityObjectBuilder.buildReferencedEntityObject(referencedEntitySchema);
        GraphQLFieldDefinition referencedEntityField = ((GraphQLFieldDefinition.Builder)ReferenceDescriptor.GROUP_ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)referencedEntityObject)).build();
        return new BuiltFieldDescriptor(referencedEntityField, new ReferencedGroupDataFetcher());
    }

    @Nonnull
    private static GraphQLOutputType buildReferencedEntityObject(@Nullable EntitySchemaContract referencedEntitySchema) {
        if (referencedEntitySchema != null) {
            return GraphQLTypeReference.typeRef((String)GraphQLEntityDescriptor.THIS.name(new NamedSchemaContract[]{referencedEntitySchema}));
        }
        return GraphQLTypeReference.typeRef((String)GraphQLEntityDescriptor.THIS_REFERENCE.name());
    }

    @Nonnull
    private GraphQLObjectType buildPriceObject() {
        this.buildingContext.registerDataFetcher(PriceDescriptor.THIS, PriceDescriptor.PRICE_WITH_TAX, new PriceBigDecimalDataFetcher(PriceDescriptor.PRICE_WITH_TAX.name()));
        this.buildingContext.registerDataFetcher(PriceDescriptor.THIS, PriceDescriptor.PRICE_WITHOUT_TAX, new PriceBigDecimalDataFetcher(PriceDescriptor.PRICE_WITHOUT_TAX.name()));
        this.buildingContext.registerDataFetcher(PriceDescriptor.THIS, PriceDescriptor.TAX_RATE, new PriceBigDecimalDataFetcher(PriceDescriptor.TAX_RATE.name()));
        return ((GraphQLObjectType.Builder)PriceDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).field((GraphQLFieldDefinition.Builder)PriceDescriptor.PRICE_WITHOUT_TAX.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer.with(this.priceFieldDecorator))).field((GraphQLFieldDefinition.Builder)PriceDescriptor.PRICE_WITH_TAX.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer.with(this.priceFieldDecorator))).field((GraphQLFieldDefinition.Builder)PriceDescriptor.TAX_RATE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer.with(this.priceFieldDecorator))).build();
    }

    public static enum EntityObjectVariant {
        DEFAULT,
        NON_HIERARCHICAL;

    }
}

