/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.PropertyDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.FormattableBigDecimal;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.BigDecimalFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.utils.Assert;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BigDecimalDataFetcher
implements DataFetcher<FormattableBigDecimal> {
    private final DataFetcher<BigDecimal> delegate;

    public BigDecimalDataFetcher(@Nonnull String propertyName) {
        this.delegate = new PropertyDataFetcher(propertyName);
    }

    public BigDecimalDataFetcher(@Nonnull DataFetcher<BigDecimal> delegate) {
        this.delegate = delegate;
    }

    @Nullable
    public FormattableBigDecimal get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        return Optional.ofNullable((BigDecimal)this.delegate.get(environment)).map(value -> {
            boolean shouldBeFormatted = this.shouldBeFormatted(environment);
            if (!shouldBeFormatted) {
                return new FormattableBigDecimal((BigDecimal)value, null);
            }
            this.validateRequiredArguments(environment);
            return this.wrapBigDecimal((BigDecimal)value, environment);
        }).orElse(null);
    }

    protected boolean shouldBeFormatted(@Nonnull DataFetchingEnvironment environment) {
        return (Boolean)environment.getArgumentOrDefault(BigDecimalFieldHeaderDescriptor.FORMATTED.name(), (Object)false);
    }

    protected void validateRequiredArguments(@Nonnull DataFetchingEnvironment environment) {
        Locale locale = ((EntityQueryContext)environment.getLocalContext()).getDesiredLocale();
        Assert.notNull((Object)locale, () -> {
            String parentFieldName = environment.getExecutionStepInfo().getParent().getFieldDefinition().getName();
            return new GraphQLInvalidArgumentException("Missing specified locale for formatted BigDecimal value. Specify custom locale on parent field `" + parentFieldName + "` or in main query.");
        });
    }

    @Nonnull
    protected FormattableBigDecimal wrapBigDecimal(@Nonnull BigDecimal value, @Nonnull DataFetchingEnvironment environment) {
        Locale locale = ((EntityQueryContext)environment.getLocalContext()).getDesiredLocale();
        return new FormattableBigDecimal(value, locale);
    }
}

