/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.exception.EvitaError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.externalApi.exception.HttpExchangeException;
import io.evitadb.externalApi.graphql.io.ErrorDto;
import io.evitadb.externalApi.http.ExternalApiExceptionHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLExceptionHandler
extends ExternalApiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQLExceptionHandler.class);
    @Nonnull
    private final ObjectMapper objectMapper;

    public GraphQLExceptionHandler(@Nonnull ObjectMapper objectMapper, @Nonnull HttpHandler next) {
        super(next);
        this.objectMapper = objectMapper;
    }

    @Nonnull
    protected String getExternalApiCode() {
        return "graphQL";
    }

    protected void renderError(@Nonnull EvitaError evitaError, @Nonnull HttpServerExchange exchange) {
        if (evitaError instanceof HttpExchangeException) {
            HttpExchangeException httpExchangeException = (HttpExchangeException)evitaError;
            this.setResponse(exchange, httpExchangeException.getStatusCode(), (EvitaError)httpExchangeException);
        } else if (evitaError instanceof EvitaInvalidUsageException) {
            this.setResponse(exchange, 400, evitaError);
        } else {
            this.setResponse(exchange, 500, evitaError);
        }
    }

    private void setResponse(@Nonnull HttpServerExchange exchange, int statusCode, @Nonnull EvitaError evitaError) {
        this.setResponse(exchange, statusCode, "application/json", this.serializeError(evitaError));
    }

    private String serializeError(@Nonnull EvitaError evitaError) {
        ErrorDto errorDto = new ErrorDto(evitaError.getErrorCode(), evitaError.getPublicMessage());
        try {
            return this.objectMapper.writeValueAsString((Object)errorDto);
        }
        catch (JsonProcessingException e) {
            log.error("Could not serialize ErrorDto in GraphQL API: {}", (Object)e.getMessage());
            return "";
        }
    }
}

