/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.PropertyDataFetcher;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.filter.FilterGroupBy;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.order.OrderGroupBy;
import io.evitadb.api.query.require.HierarchyNode;
import io.evitadb.api.query.require.HierarchyStopAt;
import io.evitadb.api.requestResponse.extraResult.FacetSummary;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntityAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ExternalEntityDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.HierarchyDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.DataChunkDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordPageDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordStripDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.AttributeHistogramDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.FacetSummaryDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HistogramDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.graphql.api.builder.BuiltFieldDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.builder.CatalogGraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.GraphQLConstraintSchemaBuildingContext;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.OrderConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.builder.constraint.RequireConstraintSchemaBuilder;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ResponseHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.FacetGroupStatisticsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.FacetStatisticsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyChildrenHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyFromNodeHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyFromRootHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfReferenceDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfReferenceHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfSelfDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyOfSelfHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchyParentsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.HierarchySiblingsHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.extraResult.LevelInfoDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.RecordPageDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.RecordStripDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.AttributeHistogramDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.AttributeHistogramForSingleAttributeDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.AttributeHistogramsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.ExtraResultsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.FacetGroupStatisticsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.FacetSummaryDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.HierarchyDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.NonGroupedFacetGroupStatisticsDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.PriceHistogramDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.QueryTelemetryDataFetcher;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult.SpecificHierarchyDataFetcher;
import io.evitadb.externalApi.graphql.api.dataType.GraphQLScalars;
import io.evitadb.externalApi.graphql.api.model.ObjectDescriptorToGraphQLInputObjectTransformer;
import io.evitadb.externalApi.graphql.api.model.ObjectDescriptorToGraphQLObjectTransformer;
import io.evitadb.externalApi.graphql.api.model.PropertyDescriptorToGraphQLArgumentTransformer;
import io.evitadb.externalApi.graphql.api.model.PropertyDescriptorToGraphQLFieldTransformer;
import io.evitadb.externalApi.graphql.api.model.PropertyDescriptorToGraphQLInputFieldTransformer;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FullResponseObjectBuilder {
    private static final ObjectMapper QUERY_TELEMETRY_OBJECT_MAPPER = new ObjectMapper();
    @Nonnull
    private final CatalogGraphQLSchemaBuildingContext buildingContext;
    @Nonnull
    private final PropertyDescriptorToGraphQLArgumentTransformer argumentBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToGraphQLObjectTransformer objectBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToGraphQLInputObjectTransformer inputObjectBuilderTransformer;
    @Nonnull
    private final PropertyDescriptorToGraphQLFieldTransformer fieldBuilderTransformer;
    @Nonnull
    private final PropertyDescriptorToGraphQLInputFieldTransformer inputFieldBuilderTransformer;
    @Nonnull
    private final FilterConstraintSchemaBuilder filterConstraintSchemaBuilder;
    @Nonnull
    private final OrderConstraintSchemaBuilder orderConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder extraResultRequireConstraintSchemaBuilder;

    public FullResponseObjectBuilder(@Nonnull CatalogGraphQLSchemaBuildingContext buildingContext, @Nonnull PropertyDescriptorToGraphQLArgumentTransformer argumentBuilderTransformer, @Nonnull ObjectDescriptorToGraphQLObjectTransformer objectBuilderTransformer, @Nonnull ObjectDescriptorToGraphQLInputObjectTransformer inputObjectBuilderTransformer, @Nonnull PropertyDescriptorToGraphQLFieldTransformer fieldBuilderTransformer, @Nonnull PropertyDescriptorToGraphQLInputFieldTransformer inputFieldBuilderTransformer, @Nonnull GraphQLConstraintSchemaBuildingContext constraintSchemaBuildingContext, @Nonnull FilterConstraintSchemaBuilder filterConstraintSchemaBuilder, @Nonnull OrderConstraintSchemaBuilder orderConstraintSchemaBuilder) {
        this.buildingContext = buildingContext;
        this.argumentBuilderTransformer = argumentBuilderTransformer;
        this.objectBuilderTransformer = objectBuilderTransformer;
        this.inputObjectBuilderTransformer = inputObjectBuilderTransformer;
        this.fieldBuilderTransformer = fieldBuilderTransformer;
        this.inputFieldBuilderTransformer = inputFieldBuilderTransformer;
        this.filterConstraintSchemaBuilder = filterConstraintSchemaBuilder;
        this.orderConstraintSchemaBuilder = orderConstraintSchemaBuilder;
        this.extraResultRequireConstraintSchemaBuilder = RequireConstraintSchemaBuilder.forExtraResultsRequire(constraintSchemaBuildingContext, new AtomicReference<FilterConstraintSchemaBuilder>(filterConstraintSchemaBuilder));
    }

    public void buildCommonTypes() {
        this.buildingContext.registerType((GraphQLType)((GraphQLObjectType.Builder)HistogramDescriptor.BucketDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType((GraphQLType)this.buildHistogramObject());
        this.buildingContext.registerType((GraphQLType)this.buildAttributeNamedHistogramObject());
        this.buildingContext.registerType((GraphQLType)this.buildFacetRequestImpactObject());
    }

    @Nonnull
    public GraphQLObjectType build(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = ResponseDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder responseObjectBuilder = ((GraphQLObjectType.Builder)ResponseDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        LinkedList<BuiltFieldDescriptor> responseFields = new LinkedList<BuiltFieldDescriptor>();
        responseFields.add(this.buildRecordPageField(entitySchema));
        responseFields.add(this.buildRecordStripField(entitySchema));
        this.buildExtraResultsField(entitySchema).ifPresent(responseFields::add);
        responseFields.forEach(responseField -> this.buildingContext.registerFieldToObject(objectName, responseObjectBuilder, (BuiltFieldDescriptor)responseField));
        return responseObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildRecordPageField(@Nonnull EntitySchemaContract entitySchema) {
        GraphQLObjectType recordPageObject = this.buildRecordPageObject(entitySchema);
        GraphQLFieldDefinition recordPageField = ((GraphQLFieldDefinition.Builder)ResponseDescriptor.RECORD_PAGE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)recordPageObject).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.NUMBER.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.RecordPageFieldHeaderDescriptor.SIZE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(recordPageField, new RecordPageDataFetcher());
    }

    @Nonnull
    private GraphQLObjectType buildRecordPageObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = RecordPageDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        return ((GraphQLObjectType.Builder)RecordPageDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName).field(((GraphQLFieldDefinition.Builder)DataChunkDescriptor.DATA.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}))))))).build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildRecordStripField(@Nonnull EntitySchemaContract entitySchema) {
        GraphQLObjectType recordStripObject = this.buildRecordStripObject(entitySchema);
        GraphQLFieldDefinition recordStripField = ((GraphQLFieldDefinition.Builder)ResponseDescriptor.RECORD_STRIP.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)recordStripObject).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.OFFSET.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.RecordStripFieldHeaderDescriptor.LIMIT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build();
        return new BuiltFieldDescriptor(recordStripField, new RecordStripDataFetcher());
    }

    @Nonnull
    private GraphQLObjectType buildRecordStripObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = RecordStripDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        return ((GraphQLObjectType.Builder)RecordStripDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName).field(((GraphQLFieldDefinition.Builder)DataChunkDescriptor.DATA.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}))))))).build();
    }

    @Nonnull
    private Optional<BuiltFieldDescriptor> buildExtraResultsField(@Nonnull EntitySchemaContract entitySchema) {
        Optional<GraphQLObjectType> extraResultsObject = this.buildExtraResultsObject(entitySchema);
        if (extraResultsObject.isEmpty()) {
            return Optional.empty();
        }
        GraphQLFieldDefinition extraResultsField = ((GraphQLFieldDefinition.Builder)ResponseDescriptor.EXTRA_RESULTS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)((GraphQLType)extraResultsObject.get()))).build();
        return Optional.of(new BuiltFieldDescriptor(extraResultsField, new ExtraResultsDataFetcher()));
    }

    @Nonnull
    private Optional<GraphQLObjectType> buildExtraResultsObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = ExtraResultsDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder extraResultsObjectBuilder = ((GraphQLObjectType.Builder)ExtraResultsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        ArrayList<BuiltFieldDescriptor> extraResultFields = new ArrayList<BuiltFieldDescriptor>(10);
        this.buildAttributeHistogramField(entitySchema).ifPresent(extraResultFields::add);
        FullResponseObjectBuilder.buildAttributeHistogramsField(entitySchema).ifPresent(extraResultFields::add);
        this.buildPriceHistogramField(entitySchema).ifPresent(extraResultFields::add);
        this.buildFacetSummaryField(entitySchema).ifPresent(extraResultFields::add);
        this.buildHierarchyField(entitySchema).ifPresent(extraResultFields::add);
        extraResultFields.add(this.buildQueryTelemetryField());
        if (extraResultFields.isEmpty()) {
            return Optional.empty();
        }
        extraResultFields.forEach(extraResultField -> this.buildingContext.registerFieldToObject(objectName, extraResultsObjectBuilder, (BuiltFieldDescriptor)extraResultField));
        return Optional.of(extraResultsObjectBuilder.build());
    }

    @Nonnull
    private Optional<BuiltFieldDescriptor> buildAttributeHistogramField(@Nonnull EntitySchemaContract entitySchema) {
        Optional<GraphQLObjectType> attributeHistogramObject = this.buildAttributeHistogramObject(entitySchema);
        if (attributeHistogramObject.isEmpty()) {
            return Optional.empty();
        }
        GraphQLFieldDefinition attributeHistogramField = ((GraphQLFieldDefinition.Builder)ExtraResultsDescriptor.ATTRIBUTE_HISTOGRAM.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)attributeHistogramObject.get()).build();
        return Optional.of(new BuiltFieldDescriptor(attributeHistogramField, new AttributeHistogramDataFetcher()));
    }

    @Nonnull
    private Optional<GraphQLObjectType> buildAttributeHistogramObject(@Nonnull EntitySchemaContract entitySchema) {
        List<EntityAttributeSchemaContract> attributeSchemas = entitySchema.getAttributes().values().stream().filter(attributeSchema -> attributeSchema.isFilterable() && Number.class.isAssignableFrom(attributeSchema.getPlainType())).toList();
        if (attributeSchemas.isEmpty()) {
            return Optional.empty();
        }
        String objectName = AttributeHistogramDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder attributeHistogramsObjectBuilder = ((GraphQLObjectType.Builder)AttributeHistogramDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        attributeSchemas.forEach(attributeSchema -> {
            BuiltFieldDescriptor fieldForSingleAttribute = this.buildAttributeHistogramForSingleAttributeField((AttributeSchemaContract)attributeSchema);
            this.buildingContext.registerFieldToObject(objectName, attributeHistogramsObjectBuilder, fieldForSingleAttribute);
        });
        return Optional.of(attributeHistogramsObjectBuilder.build());
    }

    @Nonnull
    private BuiltFieldDescriptor buildAttributeHistogramForSingleAttributeField(@Nonnull AttributeSchemaContract attributeSchema) {
        GraphQLFieldDefinition attributeFieldForSingleAttribute = GraphQLFieldDefinition.newFieldDefinition().name(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).type((GraphQLOutputType)GraphQLTypeReference.typeRef((String)HistogramDescriptor.THIS.name())).build();
        return new BuiltFieldDescriptor(attributeFieldForSingleAttribute, new AttributeHistogramForSingleAttributeDataFetcher(attributeSchema));
    }

    @Nonnull
    private static Optional<BuiltFieldDescriptor> buildAttributeHistogramsField(@Nonnull EntitySchemaContract entitySchema) {
        GraphQLFieldDefinition attributeHistogramField = GraphQLFieldDefinition.newFieldDefinition().name("attributeHistograms").type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)"AttributeNamedHistogram")))).argument(a -> a.name("attributes").type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)GraphQLScalars.STRING))))).build();
        return Optional.of(new BuiltFieldDescriptor(attributeHistogramField, new AttributeHistogramsDataFetcher(entitySchema)));
    }

    @Nonnull
    private Optional<BuiltFieldDescriptor> buildPriceHistogramField(@Nonnull EntitySchemaContract entitySchema) {
        if (entitySchema.getCurrencies().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)ExtraResultsDescriptor.PRICE_HISTOGRAM.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).build(), new PriceHistogramDataFetcher()));
    }

    @Nonnull
    private Optional<BuiltFieldDescriptor> buildFacetSummaryField(@Nonnull EntitySchemaContract entitySchema) {
        Optional<GraphQLObjectType> facetSummaryObject = this.buildFacetSummaryObject(entitySchema);
        if (facetSummaryObject.isEmpty()) {
            return Optional.empty();
        }
        GraphQLFieldDefinition facetSummaryField = ((GraphQLFieldDefinition.Builder)ExtraResultsDescriptor.FACET_SUMMARY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)facetSummaryObject.get()).build();
        return Optional.of(new BuiltFieldDescriptor(facetSummaryField, new FacetSummaryDataFetcher()));
    }

    @Nonnull
    private Optional<GraphQLObjectType> buildFacetSummaryObject(@Nonnull EntitySchemaContract entitySchema) {
        List<ReferenceSchemaContract> referenceSchemas = entitySchema.getReferences().values().stream().filter(ReferenceSchemaContract::isFaceted).toList();
        if (referenceSchemas.isEmpty()) {
            return Optional.empty();
        }
        String objectName = FacetSummaryDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder facetSummaryObjectBuilder = ((GraphQLObjectType.Builder)FacetSummaryDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        referenceSchemas.forEach(referenceSchema -> {
            BuiltFieldDescriptor facetGroupStatisticsField = this.buildFacetGroupStatisticsField(entitySchema, (ReferenceSchemaContract)referenceSchema);
            this.buildingContext.registerFieldToObject(objectName, facetSummaryObjectBuilder, facetGroupStatisticsField);
        });
        return Optional.of(facetSummaryObjectBuilder.build());
    }

    @Nonnull
    private BuiltFieldDescriptor buildFacetGroupStatisticsField(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        GraphQLObjectType facetGroupStatisticsObject = this.buildFacetGroupStatisticsObject(entitySchema, referenceSchema);
        boolean isGrouped = referenceSchema.getReferencedGroupType() != null;
        GraphQLFieldDefinition.Builder facetGroupStatisticsFieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION));
        if (isGrouped) {
            facetGroupStatisticsFieldBuilder.type((GraphQLOutputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)facetGroupStatisticsObject)));
        } else {
            facetGroupStatisticsFieldBuilder.type((GraphQLOutputType)facetGroupStatisticsObject);
        }
        if (referenceSchema.getReferencedGroupType() != null) {
            Object groupEntityDataLocator = referenceSchema.isReferencedGroupTypeManaged() ? new EntityDataLocator(referenceSchema.getReferencedGroupType()) : new ExternalEntityDataLocator(referenceSchema.getReferencedGroupType());
            GraphQLInputType filterGroupByConstraint = (GraphQLInputType)this.filterConstraintSchemaBuilder.build((DataLocator)groupEntityDataLocator, FilterGroupBy.class);
            GraphQLInputType orderGroupByConstraint = (GraphQLInputType)this.orderConstraintSchemaBuilder.build((DataLocator)groupEntityDataLocator, OrderGroupBy.class);
            facetGroupStatisticsFieldBuilder.argument(((GraphQLArgument.Builder)FacetGroupStatisticsHeaderDescriptor.FILTER_GROUP_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(filterGroupByConstraint)).argument(((GraphQLArgument.Builder)FacetGroupStatisticsHeaderDescriptor.ORDER_GROUP_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(orderGroupByConstraint));
        }
        return new BuiltFieldDescriptor(facetGroupStatisticsFieldBuilder.build(), (DataFetcher<?>)(isGrouped ? new FacetGroupStatisticsDataFetcher(referenceSchema) : new NonGroupedFacetGroupStatisticsDataFetcher(referenceSchema)));
    }

    @Nonnull
    private GraphQLObjectType buildFacetGroupStatisticsObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        String objectName = FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, referenceSchema});
        GraphQLObjectType.Builder facetGroupStatisticsBuilder = ((GraphQLObjectType.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        if (referenceSchema.getReferencedGroupType() != null) {
            this.buildingContext.registerFieldToObject(objectName, facetGroupStatisticsBuilder, this.buildFacetGroupEntityField(referenceSchema));
        }
        this.buildingContext.registerFieldToObject(objectName, facetGroupStatisticsBuilder, this.buildFacetStatisticsField(entitySchema, referenceSchema));
        return facetGroupStatisticsBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildFacetGroupEntityField(@Nonnull ReferenceSchemaContract referenceSchema) {
        EntitySchemaContract groupEntitySchema = referenceSchema.isReferencedGroupTypeManaged() ? (EntitySchemaContract)Optional.ofNullable(referenceSchema.getReferencedGroupType()).map(groupType -> this.buildingContext.getSchema().getEntitySchemaOrThrowException(groupType)).orElse(null) : null;
        GraphQLOutputType groupEntityObject = FullResponseObjectBuilder.buildReferencedEntityObject(groupEntitySchema);
        GraphQLFieldDefinition groupEntityField = ((GraphQLFieldDefinition.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.GROUP_ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type(groupEntityObject).build();
        return new BuiltFieldDescriptor(groupEntityField, null);
    }

    @Nonnull
    private BuiltFieldDescriptor buildFacetStatisticsField(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        Object facetEntityDataLocator = referenceSchema.isReferencedEntityTypeManaged() ? new EntityDataLocator(referenceSchema.getReferencedEntityType()) : new ExternalEntityDataLocator(referenceSchema.getReferencedEntityType());
        GraphQLInputType filterByConstraint = (GraphQLInputType)this.filterConstraintSchemaBuilder.build((DataLocator)facetEntityDataLocator, FilterBy.class);
        GraphQLInputType orderByConstraint = (GraphQLInputType)this.orderConstraintSchemaBuilder.build((DataLocator)facetEntityDataLocator, OrderBy.class);
        GraphQLObjectType facetStatisticsObject = this.buildFacetStatisticsObject(entitySchema, referenceSchema);
        GraphQLFieldDefinition facetStatisticsField = ((GraphQLFieldDefinition.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)facetStatisticsObject)))).argument(((GraphQLArgument.Builder)FacetStatisticsHeaderDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(filterByConstraint)).argument(((GraphQLArgument.Builder)FacetStatisticsHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(orderByConstraint)).build();
        return new BuiltFieldDescriptor(facetStatisticsField, null);
    }

    @Nonnull
    private GraphQLObjectType buildFacetStatisticsObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        EntitySchemaContract facetEntitySchema = referenceSchema.isReferencedEntityTypeManaged() ? this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType()) : null;
        GraphQLOutputType facetEntityObject = FullResponseObjectBuilder.buildReferencedEntityObject(facetEntitySchema);
        return ((GraphQLObjectType.Builder)FacetSummaryDescriptor.FacetStatisticsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(FacetSummaryDescriptor.FacetStatisticsDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, referenceSchema})).field(((GraphQLFieldDefinition.Builder)FacetSummaryDescriptor.FacetStatisticsDescriptor.FACET_ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type(facetEntityObject)).build();
    }

    @Nonnull
    private Optional<BuiltFieldDescriptor> buildHierarchyField(@Nonnull EntitySchemaContract entitySchema) {
        List<ReferenceSchemaContract> referenceSchemas = entitySchema.getReferences().values().stream().filter(referenceSchema -> referenceSchema.isReferencedEntityTypeManaged() && this.buildingContext.getSchema().getEntitySchema(referenceSchema.getReferencedEntityType()).map(EntitySchemaContract::isWithHierarchy).orElseThrow(() -> new GraphQLSchemaBuildingError("Reference `" + referenceSchema.getName() + "` should have existing entity schema but no schema found.")) != false).toList();
        if (referenceSchemas.isEmpty() && !entitySchema.isWithHierarchy()) {
            return Optional.empty();
        }
        GraphQLObjectType hierarchyObject = this.buildHierarchyObject(entitySchema, referenceSchemas);
        GraphQLFieldDefinition hierarchyField = ((GraphQLFieldDefinition.Builder)ExtraResultsDescriptor.HIERARCHY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)hierarchyObject).build();
        return Optional.of(new BuiltFieldDescriptor(hierarchyField, new HierarchyDataFetcher(entitySchema.getReferences().values())));
    }

    @Nonnull
    private GraphQLObjectType buildHierarchyObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull List<ReferenceSchemaContract> referenceSchemas) {
        String objectName = HierarchyDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLObjectType.Builder hierarchyStatisticsObjectBuilder = ((GraphQLObjectType.Builder)HierarchyDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        if (entitySchema.isWithHierarchy()) {
            this.buildingContext.registerFieldToObject(objectName, hierarchyStatisticsObjectBuilder, this.buildHierarchyOfSelfField(entitySchema));
        }
        referenceSchemas.forEach(referenceSchema -> this.buildingContext.registerFieldToObject(objectName, hierarchyStatisticsObjectBuilder, this.buildHierarchyOfReferenceField(entitySchema, (ReferenceSchemaContract)referenceSchema)));
        return hierarchyStatisticsObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyOfSelfField(@Nonnull EntitySchemaContract entitySchema) {
        GraphQLObjectType hierarchyOfSelfObject = this.buildHierarchyOfSelfObject(entitySchema);
        GraphQLInputType orderByConstraint = (GraphQLInputType)this.orderConstraintSchemaBuilder.build((DataLocator)new EntityDataLocator(entitySchema.getName()));
        GraphQLFieldDefinition hierarchyOfSelfField = ((GraphQLFieldDefinition.Builder)HierarchyDescriptor.SELF.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)hierarchyOfSelfObject)).argument(((GraphQLArgument.Builder)HierarchyOfSelfHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(orderByConstraint)).build();
        return new BuiltFieldDescriptor(hierarchyOfSelfField, null);
    }

    @Nonnull
    private GraphQLObjectType buildHierarchyOfSelfObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = HierarchyOfSelfDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, entitySchema});
        HierarchyDataLocator selfHierarchyConstraintDataLocator = new HierarchyDataLocator(entitySchema.getName());
        GraphQLInputType nodeConstraint = (GraphQLInputType)this.extraResultRequireConstraintSchemaBuilder.build((DataLocator)selfHierarchyConstraintDataLocator, HierarchyNode.class);
        GraphQLInputType stopAtConstraint = (GraphQLInputType)this.extraResultRequireConstraintSchemaBuilder.build((DataLocator)selfHierarchyConstraintDataLocator, HierarchyStopAt.class);
        GraphQLInputObjectType parentsSiblingsSpecification = ((GraphQLInputObjectType.Builder)HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.THIS.to((ObjectDescriptorTransformer)this.inputObjectBuilderTransformer)).name(HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.THIS.name(new NamedSchemaContract[]{entitySchema, entitySchema})).field(((GraphQLInputObjectField.Builder)HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.STOP_AT.to((PropertyDescriptorTransformer)this.inputFieldBuilderTransformer)).type(stopAtConstraint)).build();
        GraphQLObjectType selfLevelInfoObject = this.buildSelfLevelInfoObject(entitySchema);
        GraphQLObjectType.Builder hierarchyOfSelfObjectBuilder = ((GraphQLObjectType.Builder)HierarchyOfSelfDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfSelfObjectBuilder, this.buildHierarchyFromRootField(stopAtConstraint, selfLevelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfSelfObjectBuilder, this.buildHierarchyFromNodeField(nodeConstraint, stopAtConstraint, selfLevelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfSelfObjectBuilder, this.buildHierarchyChildrenField(stopAtConstraint, selfLevelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfSelfObjectBuilder, this.buildHierarchyParentsField(stopAtConstraint, parentsSiblingsSpecification, selfLevelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfSelfObjectBuilder, this.buildHierarchySiblingsField(stopAtConstraint, selfLevelInfoObject));
        return hierarchyOfSelfObjectBuilder.build();
    }

    @Nonnull
    private GraphQLObjectType buildSelfLevelInfoObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = LevelInfoDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, entitySchema});
        GraphQLObjectType.Builder selfLevelInfoObjectBuilder = ((GraphQLObjectType.Builder)LevelInfoDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        this.buildingContext.registerFieldToObject(objectName, selfLevelInfoObjectBuilder, this.buildSelfLevelInfoEntityField(entitySchema));
        return selfLevelInfoObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildSelfLevelInfoEntityField(@Nonnull EntitySchemaContract entitySchema) {
        String referencedEntityObjectName = EntityDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        GraphQLFieldDefinition entityField = ((GraphQLFieldDefinition.Builder)LevelInfoDescriptor.ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)referencedEntityObjectName))).build();
        return new BuiltFieldDescriptor(entityField, null);
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyOfReferenceField(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        GraphQLObjectType hierarchyOfReferenceObject = this.buildHierarchyOfReferenceObject(entitySchema, referenceSchema);
        GraphQLFieldDefinition.Builder hierarchyOfReferenceFieldBuilder = ((GraphQLFieldDefinition.Builder)HierarchyDescriptor.REFERENCE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(HierarchyDescriptor.REFERENCE.description(new Object[]{referenceSchema.getReferencedEntityType()})).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)hierarchyOfReferenceObject)).argument((GraphQLArgument.Builder)HierarchyOfReferenceHeaderDescriptor.EMPTY_HIERARCHICAL_ENTITY_BEHAVIOUR.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer));
        Object hierarchyDataLocator = referenceSchema.isReferencedEntityTypeManaged() ? new EntityDataLocator(referenceSchema.getReferencedEntityType()) : new ExternalEntityDataLocator(referenceSchema.getReferencedEntityType());
        GraphQLInputType orderByConstraint = (GraphQLInputType)this.orderConstraintSchemaBuilder.build((DataLocator)hierarchyDataLocator);
        hierarchyOfReferenceFieldBuilder.argument(((GraphQLArgument.Builder)HierarchyOfReferenceHeaderDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(orderByConstraint));
        return new BuiltFieldDescriptor(hierarchyOfReferenceFieldBuilder.build(), null);
    }

    @Nonnull
    private GraphQLObjectType buildHierarchyOfReferenceObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        String objectName = HierarchyOfReferenceDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, referenceSchema});
        HierarchyDataLocator referenceHierarchyConstraintDataLocator = new HierarchyDataLocator(entitySchema.getName(), referenceSchema.getName());
        GraphQLInputType nodeConstraint = (GraphQLInputType)this.extraResultRequireConstraintSchemaBuilder.build((DataLocator)referenceHierarchyConstraintDataLocator, HierarchyNode.class);
        GraphQLInputType stopAtConstraint = (GraphQLInputType)this.extraResultRequireConstraintSchemaBuilder.build((DataLocator)referenceHierarchyConstraintDataLocator, HierarchyStopAt.class);
        GraphQLInputObjectType parentsSiblingsSpecification = ((GraphQLInputObjectType.Builder)HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.THIS.to((ObjectDescriptorTransformer)this.inputObjectBuilderTransformer)).name(HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.THIS.name(new NamedSchemaContract[]{entitySchema, referenceSchema})).field(((GraphQLInputObjectField.Builder)HierarchyParentsHeaderDescriptor.HierarchyParentsSiblingsSpecification.STOP_AT.to((PropertyDescriptorTransformer)this.inputFieldBuilderTransformer)).type(stopAtConstraint)).build();
        GraphQLObjectType levelInfoObject = this.buildLevelInfoObject(entitySchema, referenceSchema);
        GraphQLObjectType.Builder hierarchyOfReferenceObjectBuilder = ((GraphQLObjectType.Builder)HierarchyOfReferenceDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfReferenceObjectBuilder, this.buildHierarchyFromRootField(stopAtConstraint, levelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfReferenceObjectBuilder, this.buildHierarchyFromNodeField(nodeConstraint, stopAtConstraint, levelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfReferenceObjectBuilder, this.buildHierarchyChildrenField(stopAtConstraint, levelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfReferenceObjectBuilder, this.buildHierarchyParentsField(stopAtConstraint, parentsSiblingsSpecification, levelInfoObject));
        this.buildingContext.registerFieldToObject(objectName, hierarchyOfReferenceObjectBuilder, this.buildHierarchySiblingsField(stopAtConstraint, levelInfoObject));
        return hierarchyOfReferenceObjectBuilder.build();
    }

    @Nonnull
    private GraphQLObjectType buildLevelInfoObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema) {
        String objectName = LevelInfoDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema, referenceSchema});
        GraphQLObjectType.Builder levelInfoObjectBuilder = ((GraphQLObjectType.Builder)LevelInfoDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        this.buildingContext.registerFieldToObject(objectName, levelInfoObjectBuilder, this.buildLevelInfoEntityField(referenceSchema));
        return levelInfoObjectBuilder.build();
    }

    @Nonnull
    private BuiltFieldDescriptor buildLevelInfoEntityField(@Nonnull ReferenceSchemaContract referenceSchema) {
        EntitySchemaContract referencedEntitySchema = this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType());
        String referencedEntityObjectName = EntityDescriptor.THIS.name(new NamedSchemaContract[]{referencedEntitySchema});
        GraphQLFieldDefinition entityField = ((GraphQLFieldDefinition.Builder)LevelInfoDescriptor.ENTITY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLTypeReference.typeRef((String)referencedEntityObjectName))).build();
        return new BuiltFieldDescriptor(entityField, null);
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyFromRootField(@Nonnull GraphQLInputType stopAtConstraint, @Nonnull GraphQLObjectType levelInfoObject) {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)HierarchyOfDescriptor.FROM_ROOT.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)levelInfoObject)))).argument(((GraphQLArgument.Builder)HierarchyFromRootHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).argument((GraphQLArgument.Builder)HierarchyFromRootHeaderDescriptor.STATISTICS_BASE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build(), new SpecificHierarchyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyFromNodeField(@Nonnull GraphQLInputType nodeConstraint, @Nonnull GraphQLInputType stopAtConstraint, @Nonnull GraphQLObjectType levelInfoObject) {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)HierarchyOfDescriptor.FROM_NODE.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)levelInfoObject)))).argument(((GraphQLArgument.Builder)HierarchyFromNodeHeaderDescriptor.NODE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)GraphQLNonNull.nonNull((GraphQLType)nodeConstraint))).argument(((GraphQLArgument.Builder)HierarchyFromNodeHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).argument((GraphQLArgument.Builder)HierarchyFromNodeHeaderDescriptor.STATISTICS_BASE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build(), new SpecificHierarchyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyChildrenField(@Nonnull GraphQLInputType stopAtConstraint, @Nonnull GraphQLObjectType levelInfoObject) {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)HierarchyOfDescriptor.CHILDREN.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)levelInfoObject)))).argument(((GraphQLArgument.Builder)HierarchyChildrenHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).argument((GraphQLArgument.Builder)HierarchyChildrenHeaderDescriptor.STATISTICS_BASE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build(), new SpecificHierarchyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchyParentsField(@Nonnull GraphQLInputType stopAtConstraint, @Nonnull GraphQLInputObjectType parentsSiblingsSpecification, @Nonnull GraphQLObjectType levelInfoObject) {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)HierarchyOfDescriptor.PARENTS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)levelInfoObject)))).argument(((GraphQLArgument.Builder)HierarchyParentsHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).argument((GraphQLArgument.Builder)HierarchyParentsHeaderDescriptor.STATISTICS_BASE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).argument(((GraphQLArgument.Builder)HierarchyParentsHeaderDescriptor.SIBLINGS.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type((GraphQLInputType)parentsSiblingsSpecification)).build(), new SpecificHierarchyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildHierarchySiblingsField(@Nonnull GraphQLInputType stopAtConstraint, @Nonnull GraphQLObjectType levelInfoObject) {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)HierarchyOfDescriptor.SIBLINGS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)levelInfoObject)))).argument(((GraphQLArgument.Builder)HierarchySiblingsHeaderDescriptor.STOP_AT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).type(stopAtConstraint)).argument((GraphQLArgument.Builder)HierarchySiblingsHeaderDescriptor.STATISTICS_BASE.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build(), new SpecificHierarchyDataFetcher());
    }

    @Nonnull
    private BuiltFieldDescriptor buildQueryTelemetryField() {
        return new BuiltFieldDescriptor(((GraphQLFieldDefinition.Builder)ExtraResultsDescriptor.QUERY_TELEMETRY.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLScalars.OBJECT)).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.QueryTelemetryFieldHeaderDescriptor.FORMATTED.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer)).build(), new QueryTelemetryDataFetcher(QUERY_TELEMETRY_OBJECT_MAPPER));
    }

    @Nonnull
    private static GraphQLOutputType buildReferencedEntityObject(@Nullable EntitySchemaContract referencedEntitySchema) {
        if (referencedEntitySchema != null) {
            return GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS.name(new NamedSchemaContract[]{referencedEntitySchema}));
        }
        return GraphQLTypeReference.typeRef((String)EntityDescriptor.THIS_REFERENCE.name());
    }

    @Nonnull
    private GraphQLObjectType buildHistogramObject() {
        return ((GraphQLObjectType.Builder)HistogramDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).field(((GraphQLFieldDefinition.Builder)HistogramDescriptor.BUCKETS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.BucketsFieldHeaderDescriptor.REQUESTED_COUNT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer))).build();
    }

    @Nonnull
    private GraphQLObjectType buildAttributeNamedHistogramObject() {
        return ((GraphQLObjectType.Builder)HistogramDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name("AttributeNamedHistogram").field(f -> f.name("attributeName").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)GraphQLScalars.STRING))).field(((GraphQLFieldDefinition.Builder)HistogramDescriptor.BUCKETS.to((PropertyDescriptorTransformer)this.fieldBuilderTransformer)).argument((GraphQLArgument.Builder)ResponseHeaderDescriptor.BucketsFieldHeaderDescriptor.REQUESTED_COUNT.to((PropertyDescriptorTransformer)this.argumentBuilderTransformer))).build();
    }

    @Nonnull
    private GraphQLObjectType buildFacetRequestImpactObject() {
        this.buildingContext.registerDataFetcher(FacetSummaryDescriptor.FacetRequestImpactDescriptor.THIS, FacetSummaryDescriptor.FacetRequestImpactDescriptor.DIFFERENCE, (DataFetcher<?>)PropertyDataFetcher.fetching(FacetSummary.RequestImpact::difference));
        this.buildingContext.registerDataFetcher(FacetSummaryDescriptor.FacetRequestImpactDescriptor.THIS, FacetSummaryDescriptor.FacetRequestImpactDescriptor.MATCH_COUNT, (DataFetcher<?>)PropertyDataFetcher.fetching(FacetSummary.RequestImpact::matchCount));
        this.buildingContext.registerDataFetcher(FacetSummaryDescriptor.FacetRequestImpactDescriptor.THIS, FacetSummaryDescriptor.FacetRequestImpactDescriptor.HAS_SENSE, (DataFetcher<?>)PropertyDataFetcher.fetching(FacetSummary.RequestImpact::hasSense));
        return ((GraphQLObjectType.Builder)FacetSummaryDescriptor.FacetRequestImpactDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build();
    }
}

