/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.AttributeEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GlobalEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryHeaderArgumentsJoinType;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.UnknownEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUnknownEntityDataFetcher
implements DataFetcher<DataFetcherResult<SealedEntity>> {
    private static final Logger log = LoggerFactory.getLogger(GetUnknownEntityDataFetcher.class);
    @Nonnull
    private final CatalogSchemaContract catalogSchema;
    @Nonnull
    private final Set<Locale> allPossibleLocales;
    @Nonnull
    private final Function<String, EntitySchemaContract> entitySchemaFetcher;
    @Nonnull
    private final Map<String, String> entityDtoObjectTypeNameByEntityType;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public GetUnknownEntityDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull Set<Locale> allPossibleLocales) {
        this.catalogSchema = catalogSchema;
        this.allPossibleLocales = allPossibleLocales;
        this.entitySchemaFetcher = arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0);
        this.entityDtoObjectTypeNameByEntityType = CollectionUtils.createHashMap((int)catalogSchema.getEntitySchemas().size());
        catalogSchema.getEntitySchemas().forEach(entitySchema -> this.entityDtoObjectTypeNameByEntityType.put(entitySchema.getName(), entitySchema.getNameVariant(ExternalApiNamingConventions.TYPE_NAME_NAMING_CONVENTION)));
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(this.entitySchemaFetcher, filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<SealedEntity> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.catalogSchema);
        FilterBy filterBy = this.buildFilterBy(arguments);
        Require require = this.buildInitialRequire(environment);
        Query query = Query.query((FilterBy)filterBy, (Require)require);
        log.debug("Generated evitaDB query for single unknown entity fetch `{}`.", (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        SealedEntity loadedEntity = evitaSession.queryOne(query, SealedEntity.class).map(it -> {
            String entityType = it.getType();
            Optional<EntityContentRequire[]> contentRequires = this.buildEnrichingRequires(environment, entityType);
            if (contentRequires.isEmpty()) {
                log.debug("Skipping enriching entity reference `{}`. Target entity not requested.", it);
                return it;
            }
            log.debug("Enriching entity reference `{}` with `{}`.", it, (Object)Arrays.toString(contentRequires.get()));
            return (SealedEntity)evitaSession.enrichEntity((Serializable)it, contentRequires.get());
        }).orElse(null);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult();
        if (loadedEntity != null) {
            resultBuilder.data((Object)loadedEntity).localContext((Object)GetUnknownEntityDataFetcher.buildResultContext(arguments));
        }
        return resultBuilder.build();
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<AttributeEquals> filterConstraints = new LinkedList<AttributeEquals>();
        for (Map.Entry<GlobalAttributeSchemaContract, Object> attribute : arguments.globallyUniqueAttributes().entrySet()) {
            filterConstraints.add(QueryConstraints.attributeEquals((String)attribute.getKey().getName(), (Serializable)((Serializable)attribute.getValue())));
        }
        Optional.ofNullable(arguments.locale()).ifPresent(locale -> filterConstraints.add((AttributeEquals)QueryConstraints.entityLocaleEquals((Locale)locale)));
        if (arguments.join() == QueryHeaderArgumentsJoinType.AND) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        if (arguments.join() == QueryHeaderArgumentsJoinType.OR) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.or((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        throw new GraphQLInternalError("Unsupported join type `" + arguments.join() + "`.");
    }

    @Nonnull
    private Require buildInitialRequire(@Nonnull DataFetchingEnvironment environment) {
        EntityFetch entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), null, this.catalogSchema, this.allPossibleLocales).orElse(QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0]));
        return QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{entityFetch});
    }

    @Nonnull
    private Optional<EntityContentRequire[]> buildEnrichingRequires(@Nonnull DataFetchingEnvironment environment, @Nonnull String entityType) {
        List<SelectedField> targetEntityFields = SelectionSetAggregator.getImmediateFields(GlobalEntityDescriptor.TARGET_ENTITY.name(), environment.getSelectionSet());
        if (targetEntityFields.isEmpty()) {
            return Optional.empty();
        }
        Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(targetEntityFields.stream().map(SelectedField::getSelectionSet).toList(), this.entityDtoObjectTypeNameByEntityType.get(entityType)), null, this.entitySchemaFetcher.apply(entityType));
        return Optional.of(entityFetch.map(EntityFetch::getRequirements).orElse(new EntityContentRequire[0]));
    }

    @Nonnull
    private static EntityQueryContext buildResultContext(@Nonnull Arguments arguments) {
        return new EntityQueryContext(arguments.locale(), null, null, null, false);
    }

    private static Map<GlobalAttributeSchemaContract, Object> extractUniqueAttributesFromArguments(@Nonnull Map<String, Object> arguments, @Nonnull CatalogSchemaContract catalogSchema) {
        HashMap uniqueAttributes = CollectionUtils.createHashMap((int)arguments.size());
        for (Map.Entry<String, Object> argument : arguments.entrySet()) {
            String attributeName = argument.getKey();
            GlobalAttributeSchemaContract attributeSchema = catalogSchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
            if (attributeSchema == null) continue;
            Assert.isPremiseValid((boolean)attributeSchema.isUniqueGlobally(), () -> new GraphQLQueryResolvingInternalError("Cannot find entity by non-unique attribute `" + attributeName + "`."));
            Object attributeValue = argument.getValue();
            if (attributeValue == null) continue;
            uniqueAttributes.put(attributeSchema, attributeValue);
        }
        return uniqueAttributes;
    }

    private record Arguments(@Nullable Locale locale, @Nonnull QueryHeaderArgumentsJoinType join, @Nonnull Map<GlobalAttributeSchemaContract, Object> globallyUniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull CatalogSchemaContract catalogSchema) {
            Map<GlobalAttributeSchemaContract, Object> globallyUniqueAttributes = GetUnknownEntityDataFetcher.extractUniqueAttributesFromArguments(environment.getArguments(), catalogSchema);
            if (globallyUniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing globally unique attribute to identify entity.");
            }
            Locale locale = (Locale)environment.getArgument(UnknownEntityHeaderDescriptor.LOCALE.name());
            if (locale == null && globallyUniqueAttributes.keySet().stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale)) {
                throw new GraphQLInvalidArgumentException("Globally unique within locale attribute used but no locale was passed.");
            }
            QueryHeaderArgumentsJoinType join = (QueryHeaderArgumentsJoinType)((Object)environment.getArgument(UnknownEntityHeaderDescriptor.JOIN.name()));
            return new Arguments(locale, join, globallyUniqueAttributes);
        }
    }
}

