/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.builder;

import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.api.model.ObjectDescriptor;
import io.evitadb.externalApi.api.model.PropertyDescriptor;
import io.evitadb.externalApi.graphql.api.builder.BuiltFieldDescriptor;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GraphQLSchemaBuildingContext {
    @Nonnull
    private final GraphQLConfig config;
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final List<GraphQLFieldDefinition> queryFields = new LinkedList<GraphQLFieldDefinition>();
    @Nonnull
    private final List<GraphQLFieldDefinition> mutationFields = new LinkedList<GraphQLFieldDefinition>();
    @Nonnull
    private final GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
    @Nonnull
    private final GraphQLCodeRegistry.Builder registryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    @Nonnull
    private final Set<String> registeredCustomEnums = CollectionUtils.createHashSet((int)32);

    @Nonnull
    public Optional<Executor> getEvitaExecutor() {
        if (!this.config.isParallelize()) {
            return Optional.empty();
        }
        return Optional.of(this.evita.getExecutor());
    }

    public void registerCustomEnumIfAbsent(@Nonnull GraphQLEnumType customEnum) {
        if (this.registeredCustomEnums.contains(customEnum.getName())) {
            return;
        }
        this.registeredCustomEnums.add(customEnum.getName());
        this.registerType((GraphQLType)customEnum);
    }

    public void registerType(@Nonnull GraphQLType type) {
        this.schemaBuilder.additionalType(type);
    }

    public void registerTypes(@Nonnull Set<GraphQLType> types) {
        this.schemaBuilder.additionalTypes(types);
    }

    public void registerTypeResolver(@Nonnull GraphQLInterfaceType interfaceType, @Nonnull TypeResolver typeResolver) {
        this.registryBuilder.typeResolver(interfaceType, typeResolver);
    }

    public void registerTypeResolver(@Nonnull GraphQLUnionType unionType, @Nonnull TypeResolver typeResolver) {
        this.registryBuilder.typeResolver(unionType, typeResolver);
    }

    public void registerDataFetcher(@Nonnull String objectName, @Nonnull PropertyDescriptor fieldDescriptor, @Nonnull DataFetcher<?> dataFetcher) {
        this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectName, (String)fieldDescriptor.name()), dataFetcher);
    }

    public void registerDataFetcher(@Nonnull ObjectDescriptor objectDescriptor, @Nonnull PropertyDescriptor fieldDescriptor, @Nonnull DataFetcher<?> dataFetcher) {
        this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectDescriptor.name(), (String)fieldDescriptor.name()), dataFetcher);
    }

    public void registerQueryField(@Nullable BuiltFieldDescriptor queryFieldDescriptor) {
        if (queryFieldDescriptor == null) {
            return;
        }
        Assert.isPremiseValid((queryFieldDescriptor.dataFetcher() != null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Missing data fetcher for query field `" + queryFieldDescriptor.definition().getName() + "`."));
        this.queryFields.add(queryFieldDescriptor.definition());
        this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)queryFieldDescriptor.definition().getName()), queryFieldDescriptor.dataFetcher());
    }

    public void registerMutationField(@Nonnull BuiltFieldDescriptor mutationFieldDescriptor) {
        Assert.isPremiseValid((mutationFieldDescriptor.dataFetcher() != null ? 1 : 0) != 0, () -> new GraphQLSchemaBuildingError("Missing data fetcher for mutation field `" + mutationFieldDescriptor.definition().getName() + "`."));
        this.mutationFields.add(mutationFieldDescriptor.definition());
        this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Mutation", (String)mutationFieldDescriptor.definition().getName()), mutationFieldDescriptor.dataFetcher());
    }

    public void registerFieldToObject(@Nonnull String objectName, @Nonnull GraphQLObjectType.Builder objectBuilder, @Nonnull BuiltFieldDescriptor fieldDescriptor) {
        objectBuilder.field(fieldDescriptor.definition());
        if (fieldDescriptor.dataFetcher() != null) {
            this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectName, (String)fieldDescriptor.definition().getName()), fieldDescriptor.dataFetcher());
        }
    }

    public void registerFieldToObject(@Nonnull ObjectDescriptor objectDescriptor, @Nonnull GraphQLObjectType.Builder objectBuilder, @Nonnull BuiltFieldDescriptor fieldDescriptor) {
        objectBuilder.field(fieldDescriptor.definition());
        if (fieldDescriptor.dataFetcher() != null) {
            this.registryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectDescriptor.name(), (String)fieldDescriptor.definition().getName()), fieldDescriptor.dataFetcher());
        }
    }

    @Nonnull
    public GraphQLSchema buildGraphQLSchema() {
        GraphQLObjectType.Builder queryObjectBuilder = GraphQLObjectType.newObject().name("Query");
        this.queryFields.forEach(arg_0 -> ((GraphQLObjectType.Builder)queryObjectBuilder).field(arg_0));
        this.schemaBuilder.query(queryObjectBuilder.build());
        if (!this.mutationFields.isEmpty()) {
            GraphQLObjectType.Builder mutationObjectBuilder = GraphQLObjectType.newObject().name("Mutation");
            this.mutationFields.forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationObjectBuilder).field(arg_0));
            this.schemaBuilder.mutation(mutationObjectBuilder.build());
        }
        this.schemaBuilder.codeRegistry(this.registryBuilder.build());
        return this.schemaBuilder.build();
    }

    public GraphQLSchemaBuildingContext(@Nonnull GraphQLConfig config, @Nonnull Evita evita) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        this.config = config;
        this.evita = evita;
    }

    @Nonnull
    public Evita getEvita() {
        return this.evita;
    }
}

