/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.IntValue;
import graphql.schema.CoercingParseLiteralException;
import io.evitadb.dataType.ByteNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.coercing.RangeCoercing;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ByteNumberRangeCoercing
extends RangeCoercing<Byte, ByteNumberRange, Integer> {
    @Override
    protected Class<ByteNumberRange> getRangeClass() {
        return ByteNumberRange.class;
    }

    @Override
    protected Class<Integer> getTupleComponentClass() {
        return Integer.class;
    }

    @Nonnull
    protected Integer[] createTuple(@Nullable Integer from, @Nullable Integer to) {
        return new Integer[]{from, to};
    }

    @Override
    @Nonnull
    protected ByteNumberRange createRange(@Nullable Byte left, @Nullable Byte right) {
        if (left != null && right != null) {
            return ByteNumberRange.between((Byte)left, (Byte)right);
        }
        if (left != null) {
            return ByteNumberRange.from((Byte)left);
        }
        if (right != null) {
            return ByteNumberRange.to((Byte)right);
        }
        throw new GraphQLInvalidArgumentException("Both left and right arguments cannot be null!");
    }

    @Override
    @Nonnull
    protected Integer extractRangeEndFromNode(@Nonnull Object node) {
        if (!(node instanceof IntValue)) {
            throw new CoercingParseLiteralException("Item of range input value is not a integer.");
        }
        return ((IntValue)node).getValue().intValueExact();
    }

    @Override
    @Nullable
    protected Integer formatRangeEnd(@Nullable Byte end) {
        return Optional.ofNullable(end).map(e -> (int)e).orElse(null);
    }

    @Override
    @Nullable
    protected Byte parseRangeEnd(@Nullable Integer end) {
        return Optional.ofNullable(end).map(e -> new BigInteger(end.toString()).byteValueExact()).orElse(null);
    }
}

