/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.extraResult.AttributeHistogram;
import io.evitadb.api.requestResponse.extraResult.HistogramContract;
import io.evitadb.api.requestResponse.schema.EntityAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AttributeHistogramsDataFetcher
implements DataFetcher<List<Map<String, Object>>> {
    private final EntitySchemaContract entitySchema;

    @Nonnull
    public List<Map<String, Object>> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        EvitaResponse response = (EvitaResponse)environment.getSource();
        AttributeHistogram attributeHistogram = (AttributeHistogram)response.getExtraResult(AttributeHistogram.class);
        if (attributeHistogram == null) {
            return List.of();
        }
        List attributes = (List)environment.getArguments().get("attributes");
        return attributeHistogram.getHistograms().entrySet().stream().filter(h -> {
            String attributeName = ((EntityAttributeSchemaContract)this.entitySchema.getAttribute((String)h.getKey()).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Missing attribute `" + (String)h.getKey() + "`."))).getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION);
            return attributes.contains(attributeName);
        }).map(h -> Map.of("attributeName", h.getKey(), "min", ((HistogramContract)h.getValue()).getMin(), "max", ((HistogramContract)h.getValue()).getMax(), "overallCount", ((HistogramContract)h.getValue()).getOverallCount(), "buckets", ((HistogramContract)h.getValue()).getBuckets())).toList();
    }

    public AttributeHistogramsDataFetcher(EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
    }
}

