/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HistogramDescriptor;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class AttributeHistogramResolver {
    @Nonnull
    private final EntitySchemaContract entitySchema;

    @Nonnull
    public List<RequireConstraint> resolve(@Nonnull SelectionSetAggregator extraResultsSelectionSet) {
        List<SelectedField> attributeHistogramFields = extraResultsSelectionSet.getImmediateFields(ExtraResultsDescriptor.ATTRIBUTE_HISTOGRAM.name());
        List<SelectedField> attributeHistogramsFields = extraResultsSelectionSet.getImmediateFields("attributeHistograms");
        if (attributeHistogramFields.isEmpty() && attributeHistogramsFields.isEmpty()) {
            return List.of();
        }
        HashMap requestedAttributeHistograms = CollectionUtils.createHashMap((int)10);
        attributeHistogramFields.stream().flatMap(f -> SelectionSetAggregator.getImmediateFields(f.getSelectionSet()).stream()).forEach(f -> {
            AttributeSchemaContract attributeSchema = (AttributeSchemaContract)this.entitySchema.getAttributeByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Missing attribute `" + f.getName() + "`."));
            String originalAttributeName = attributeSchema.getName();
            List<SelectedField> bucketsFields = SelectionSetAggregator.getImmediateFields(HistogramDescriptor.BUCKETS.name(), f.getSelectionSet());
            Assert.isTrue((!bucketsFields.isEmpty() ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Attribute histogram for attribute `" + originalAttributeName + "` must have at least one `" + HistogramDescriptor.BUCKETS.name() + "` field."));
            bucketsFields.forEach(bucketsField -> {
                int requestedBucketCount = (Integer)bucketsField.getArguments().get("requestedCount");
                Integer alreadyRequestedBucketCount = requestedAttributeHistograms.put(originalAttributeName, requestedBucketCount);
                Assert.isTrue((alreadyRequestedBucketCount == null || alreadyRequestedBucketCount == requestedBucketCount ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Attribute histogram for attribute `" + originalAttributeName + "` was already requested with bucket count `" + alreadyRequestedBucketCount + "`. Each attribute can have maximum number of one requested bucket count."));
            });
        });
        if (!attributeHistogramsFields.isEmpty()) {
            attributeHistogramsFields.forEach(f -> {
                List<String> attributes = ((List)f.getArguments().get("attributes")).stream().map(a -> {
                    AttributeSchemaContract attributeSchema = (AttributeSchemaContract)this.entitySchema.getAttributeByName(a, ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Missing attribute `" + a + "`."));
                    return attributeSchema.getName();
                }).toList();
                List<SelectedField> bucketsFields = SelectionSetAggregator.getImmediateFields(HistogramDescriptor.BUCKETS.name(), f.getSelectionSet());
                Assert.isTrue((!bucketsFields.isEmpty() ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Attribute histograms for attributes `" + String.join((CharSequence)",", attributes) + "` must have at least one `" + HistogramDescriptor.BUCKETS.name() + "` field."));
                bucketsFields.forEach(bucketsField -> {
                    int requestedBucketCount = (Integer)bucketsField.getArguments().get("requestedCount");
                    attributes.forEach(attribute -> {
                        Integer alreadyRequestedBucketCount = requestedAttributeHistograms.put(attribute, requestedBucketCount);
                        Assert.isTrue((alreadyRequestedBucketCount == null || alreadyRequestedBucketCount == requestedBucketCount ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Attribute histogram for attribute `" + attribute + "` was already requested with bucket count `" + alreadyRequestedBucketCount + "`. Each attribute can have maximum number of one requested bucket count."));
                    });
                });
            });
        }
        return requestedAttributeHistograms.entrySet().stream().map(h -> QueryConstraints.attributeHistogram((int)((Integer)h.getValue()), (String[])new String[]{(String)h.getKey()})).toList();
    }

    public AttributeHistogramResolver(@Nonnull EntitySchemaContract entitySchema) {
        if (entitySchema == null) {
            throw new NullPointerException("entitySchema is marked non-null but is null");
        }
        this.entitySchema = entitySchema;
    }
}

