/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.dto;

import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.FormattableBigDecimal;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PriceBigDecimal
extends FormattableBigDecimal {
    private final Currency currency;

    public PriceBigDecimal(@Nonnull BigDecimal value, @Nullable Locale formatLocale, @Nullable Currency currency) {
        super(value, formatLocale);
        this.currency = currency;
        if (currency != null && formatLocale == null) {
            throw new GraphQLInvalidArgumentException("Price should be formatted with currency but no format locale is specified.");
        }
    }

    public boolean isWithCurrency() {
        return this.currency != null;
    }

    @Override
    public boolean isShouldFormat() {
        return super.isShouldFormat() || this.isWithCurrency();
    }

    @Override
    @Nonnull
    public String toFormattedString() {
        if (!this.isWithCurrency()) {
            return super.toFormattedString();
        }
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(this.getFormatLocale());
        numberFormat.setCurrency(this.getCurrency());
        return numberFormat.format(this.getValue());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriceBigDecimal)) {
            return false;
        }
        PriceBigDecimal other = (PriceBigDecimal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PriceBigDecimal;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PriceBigDecimal(super=" + super.toString() + ", currency=" + this.getCurrency() + ")";
    }
}

