/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SelectionSetAggregator {
    private static final String TYPENAME_FIELD = "__typename";
    private static final String FIELD_NAME_PATTERN_WILDCARD = "*";
    private static final List<SelectedField> EMPTY_LIST = List.of();
    @Nullable
    private final DataFetchingFieldSelectionSet originalSelectionSet;
    @Nullable
    private final List<DataFetchingFieldSelectionSet> originalSelectionSets;

    public static SelectionSetAggregator from(@Nonnull DataFetchingFieldSelectionSet originalSelectionSet) {
        return new SelectionSetAggregator(originalSelectionSet, null);
    }

    public static SelectionSetAggregator from(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets) {
        return new SelectionSetAggregator(null, originalSelectionSets);
    }

    public boolean containsImmediate(@Nonnull String fieldNamePattern) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.containsImmediate(fieldNamePattern, this.originalSelectionSet);
        }
        return SelectionSetAggregator.containsImmediate(fieldNamePattern, this.originalSelectionSets);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields() {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(this.originalSelectionSet);
        }
        return SelectionSetAggregator.getImmediateFields(this.originalSelectionSets);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields(@Nonnull String fieldName) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(fieldName, this.originalSelectionSet);
        }
        return SelectionSetAggregator.getImmediateFields(fieldName, this.originalSelectionSets);
    }

    @Nonnull
    public List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames) {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.getImmediateFields(fieldNames, this.originalSelectionSet);
        }
        return SelectionSetAggregator.getImmediateFields(fieldNames, this.originalSelectionSets);
    }

    public boolean isEmpty() {
        if (this.originalSelectionSet != null) {
            return SelectionSetAggregator.isEmpty(this.originalSelectionSet);
        }
        return SelectionSetAggregator.isEmpty(this.originalSelectionSets);
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        List immediateFields = selectionSet.getImmediateFields();
        if (fieldNamePattern.endsWith(FIELD_NAME_PATTERN_WILDCARD)) {
            String normalizedPattern = fieldNamePattern.substring(0, fieldNamePattern.length() - 1);
            for (SelectedField field : immediateFields) {
                if (!field.getName().startsWith(normalizedPattern)) continue;
                return true;
            }
        } else {
            for (SelectedField field : immediateFields) {
                if (!field.getName().equals(fieldNamePattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsImmediate(@Nonnull String fieldNamePattern, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        if (selectionSets.isEmpty()) {
            return false;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.containsImmediate(fieldNamePattern, selectionSets.get(0));
        }
        if (fieldNamePattern.endsWith(FIELD_NAME_PATTERN_WILDCARD)) {
            String normalizedPattern = fieldNamePattern.substring(0, fieldNamePattern.length() - 1);
            for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
                for (SelectedField field : selectionSet.getImmediateFields()) {
                    if (!field.getName().startsWith(normalizedPattern)) continue;
                    return true;
                }
            }
        } else {
            for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
                for (SelectedField field : selectionSet.getImmediateFields()) {
                    if (!field.getName().equals(fieldNamePattern)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull DataFetchingFieldSelectionSet selectionSet) {
        ArrayList<SelectedField> matchingFields = new ArrayList<SelectedField>(selectionSet.getImmediateFields().size());
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (field.getName().equals(TYPENAME_FIELD)) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (field.getName().equals(TYPENAME_FIELD)) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!field.getName().equals(fieldName)) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull DataFetchingFieldSelectionSet selectionSet) {
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (SelectedField field : selectionSet.getImmediateFields()) {
            if (!fieldNames.contains(field.getName())) continue;
            matchingFields.add(field);
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull String fieldName, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        if (selectionSets.isEmpty()) {
            return EMPTY_LIST;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.getImmediateFields(fieldName, selectionSets.get(0));
        }
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (!field.getName().equals(fieldName)) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    @Nonnull
    public static List<SelectedField> getImmediateFields(@Nonnull Set<String> fieldNames, @Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        if (selectionSets.isEmpty()) {
            return EMPTY_LIST;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.getImmediateFields(fieldNames, selectionSets.get(0));
        }
        LinkedList<SelectedField> matchingFields = new LinkedList<SelectedField>();
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            for (SelectedField field : selectionSet.getImmediateFields()) {
                if (!fieldNames.contains(field.getName())) continue;
                matchingFields.add(field);
            }
        }
        return Collections.unmodifiableList(matchingFields);
    }

    public static boolean isEmpty(@Nonnull DataFetchingFieldSelectionSet selectionSet) {
        return selectionSet.getImmediateFields().isEmpty();
    }

    public static boolean isEmpty(@Nonnull List<DataFetchingFieldSelectionSet> selectionSets) {
        if (selectionSets.isEmpty()) {
            return true;
        }
        if (selectionSets.size() == 1) {
            return SelectionSetAggregator.isEmpty(selectionSets.get(0));
        }
        for (DataFetchingFieldSelectionSet selectionSet : selectionSets) {
            if (SelectionSetAggregator.isEmpty(selectionSet)) continue;
            return false;
        }
        return true;
    }

    private SelectionSetAggregator(@Nullable DataFetchingFieldSelectionSet originalSelectionSet, @Nullable List<DataFetchingFieldSelectionSet> originalSelectionSets) {
        this.originalSelectionSet = originalSelectionSet;
        this.originalSelectionSets = originalSelectionSets;
    }
}

