/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public class LocalDateTimeCoercing
implements Coercing<LocalDateTime, String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final String EXPECTED_FORMAT = "yyyy-MM-ddTHH:mm:ss";

    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof LocalDateTime)) {
            throw new CoercingSerializeException("Local date time data fetcher result is not a local date time.");
        }
        try {
            return ((LocalDateTime)dataFetcherResult).truncatedTo(ChronoUnit.MILLIS).format(FORMATTER);
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalDateTime parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Local date time input is not a string.");
        }
        try {
            return LocalDateTime.parse((String)input, FORMATTER);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseValueException(this.getParseErrorMessage(ex), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalDateTime parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Local date time input is not a StringValue.");
        }
        try {
            return LocalDateTime.parse(((StringValue)input).getValue(), FORMATTER);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseLiteralException(this.getParseErrorMessage(ex), (Throwable)ex);
        }
    }

    @Nonnull
    private String getParseErrorMessage(@Nonnull DateTimeParseException ex) {
        return String.format("%s. Expected date time in format `%s`.", ex.getMessage(), EXPECTED_FORMAT);
    }
}

