/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.AttributeInSet;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.Strip;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ListUnknownEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryHeaderArgumentsJoinType;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnknownEntitiesDataFetcher
implements DataFetcher<DataFetcherResult<List<EntityClassifier>>> {
    private static final Logger log = LoggerFactory.getLogger(ListUnknownEntitiesDataFetcher.class);
    @Nonnull
    private final CatalogSchemaContract catalogSchema;
    @Nonnull
    private final Set<Locale> allPossibleLocales;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public ListUnknownEntitiesDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull Set<Locale> allPossibleLocales) {
        this.catalogSchema = catalogSchema;
        this.allPossibleLocales = allPossibleLocales;
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(__ -> {
            throw new GraphQLInternalError("Global entity shouldn't need to fetch other entities. This should never happen.");
        }, filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<List<EntityClassifier>> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.catalogSchema);
        FilterBy filterBy = this.buildFilterBy(arguments);
        Require require = this.buildRequire(environment, arguments);
        Query query = Query.query((FilterBy)filterBy, (Require)require);
        log.debug("Generated evitaDB query for single unknown entity fetch `{}`.", (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        List entities = evitaSession.queryList(query, EntityClassifier.class);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().data((Object)entities);
        if (!entities.isEmpty()) {
            resultBuilder.localContext((Object)EntityQueryContext.empty());
        }
        return resultBuilder.build();
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<AttributeInSet> filterConstraints = new LinkedList<AttributeInSet>();
        for (Map.Entry<GlobalAttributeSchemaContract, List<Object>> attribute : arguments.globallyUniqueAttributes().entrySet()) {
            GlobalAttributeSchemaContract attributeSchema = attribute.getKey();
            Serializable[] attributeValues = (Serializable[])attribute.getValue().toArray(size -> (Serializable[])Array.newInstance(attributeSchema.getPlainType(), size));
            filterConstraints.add(QueryConstraints.attributeInSet((String)attributeSchema.getName(), (Serializable[])attributeValues));
        }
        if (arguments.join() == QueryHeaderArgumentsJoinType.AND) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        if (arguments.join() == QueryHeaderArgumentsJoinType.OR) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.or((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        throw new GraphQLInternalError("Unsupported join type `" + arguments.join() + "`.");
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments) {
        LinkedList<Strip> requireConstraints = new LinkedList<Strip>();
        this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), null, this.catalogSchema, this.allPossibleLocales).ifPresent(requireConstraints::add);
        if (arguments.limit() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)0, (Integer)arguments.limit()));
        }
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    private record Arguments(@Nullable Integer limit, @Nonnull QueryHeaderArgumentsJoinType join, @Nonnull Map<GlobalAttributeSchemaContract, List<Object>> globallyUniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull CatalogSchemaContract catalogSchema) {
            HashMap<String, Object> arguments = new HashMap<String, Object>(environment.getArguments());
            Integer limit = (Integer)arguments.remove(ListUnknownEntitiesHeaderDescriptor.LIMIT.name());
            QueryHeaderArgumentsJoinType join = (QueryHeaderArgumentsJoinType)((Object)arguments.get(ListUnknownEntitiesHeaderDescriptor.JOIN.name()));
            Map<GlobalAttributeSchemaContract, List<Object>> globallyUniqueAttributes = Arguments.extractUniqueAttributesFromArguments(arguments, catalogSchema);
            if (globallyUniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing globally unique attribute to identify entity.");
            }
            return new Arguments(limit, join, globallyUniqueAttributes);
        }

        private static Map<GlobalAttributeSchemaContract, List<Object>> extractUniqueAttributesFromArguments(@Nonnull HashMap<String, Object> arguments, @Nonnull CatalogSchemaContract catalogSchema) {
            HashMap uniqueAttributes = CollectionUtils.createHashMap((int)arguments.size());
            for (Map.Entry<String, Object> argument : arguments.entrySet()) {
                String attributeName = argument.getKey();
                GlobalAttributeSchemaContract attributeSchema = catalogSchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
                if (attributeSchema == null) continue;
                Assert.isPremiseValid((boolean)attributeSchema.isUniqueGlobally(), () -> new GraphQLQueryResolvingInternalError("Cannot filter list of entities by non-unique attribute `" + attributeName + "`."));
                List attributeValues = (List)argument.getValue();
                if (attributeValues == null || attributeValues.isEmpty()) continue;
                uniqueAttributes.put(attributeSchema, attributeValues);
            }
            return uniqueAttributes;
        }
    }
}

