/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.AttributeEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.QueryHeaderArgumentsJoinType;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.UnknownEntityHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUnknownEntityDataFetcher
implements DataFetcher<DataFetcherResult<EntityClassifier>> {
    private static final Logger log = LoggerFactory.getLogger(GetUnknownEntityDataFetcher.class);
    @Nonnull
    private final CatalogSchemaContract catalogSchema;
    @Nonnull
    private final Set<Locale> allPossibleLocales;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public GetUnknownEntityDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull Set<Locale> allPossibleLocales) {
        this.catalogSchema = catalogSchema;
        this.allPossibleLocales = allPossibleLocales;
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(__ -> {
            throw new GraphQLInternalError("Global entity shouldn't need to fetch other entities. This should never happen.");
        }, filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<EntityClassifier> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.catalogSchema);
        FilterBy filterBy = this.buildFilterBy(arguments);
        Require require = this.buildRequire(environment);
        Query query = Query.query((FilterBy)filterBy, (Require)require);
        log.debug("Generated evitaDB query for single unknown entity fetch `{}`.", (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult();
        evitaSession.queryOne(query, EntityClassifier.class).ifPresent(entity -> resultBuilder.data(entity).localContext((Object)EntityQueryContext.empty()));
        return resultBuilder.build();
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<AttributeEquals> filterConstraints = new LinkedList<AttributeEquals>();
        for (Map.Entry<GlobalAttributeSchemaContract, Object> attribute : arguments.globallyUniqueAttributes().entrySet()) {
            filterConstraints.add(QueryConstraints.attributeEquals((String)attribute.getKey().getName(), (Serializable)((Serializable)attribute.getValue())));
        }
        if (arguments.join() == QueryHeaderArgumentsJoinType.AND) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        if (arguments.join() == QueryHeaderArgumentsJoinType.OR) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.or((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        throw new GraphQLInternalError("Unsupported join type `" + arguments.join() + "`.");
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment) {
        EntityFetch entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), null, this.catalogSchema, this.allPossibleLocales).orElse(null);
        return QueryConstraints.require((RequireConstraint[])new RequireConstraint[]{entityFetch});
    }

    private static Map<GlobalAttributeSchemaContract, Object> extractUniqueAttributesFromArguments(@Nonnull HashMap<String, Object> arguments, @Nonnull CatalogSchemaContract catalogSchema) {
        HashMap uniqueAttributes = CollectionUtils.createHashMap((int)arguments.size());
        for (Map.Entry<String, Object> argument : arguments.entrySet()) {
            String attributeName = argument.getKey();
            GlobalAttributeSchemaContract attributeSchema = catalogSchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
            if (attributeSchema == null) continue;
            Assert.isPremiseValid((boolean)attributeSchema.isUniqueGlobally(), () -> new GraphQLQueryResolvingInternalError("Cannot find entity by non-unique attribute `" + attributeName + "`."));
            Object attributeValue = argument.getValue();
            if (attributeValue == null) continue;
            uniqueAttributes.put(attributeSchema, attributeValue);
        }
        return uniqueAttributes;
    }

    private record Arguments(@Nonnull QueryHeaderArgumentsJoinType join, @Nonnull Map<GlobalAttributeSchemaContract, Object> globallyUniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull CatalogSchemaContract catalogSchema) {
            HashMap<String, Object> arguments = new HashMap<String, Object>(environment.getArguments());
            Map<GlobalAttributeSchemaContract, Object> globallyUniqueAttributes = GetUnknownEntityDataFetcher.extractUniqueAttributesFromArguments(arguments, catalogSchema);
            if (globallyUniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing globally unique attribute to identify entity.");
            }
            QueryHeaderArgumentsJoinType join = (QueryHeaderArgumentsJoinType)((Object)environment.getArgument(UnknownEntityHeaderDescriptor.JOIN.name()));
            return new Arguments(join, globallyUniqueAttributes);
        }
    }
}

