/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import graphql.ExecutionInput;
import io.evitadb.utils.Assert;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record GraphQLRequest(@Nonnull String query, @Nullable String operationName, @Nullable Map<String, Object> variables) {
    public GraphQLRequest {
        Assert.notNull((Object)query, (String)"Query cannot be empty.");
    }

    @JsonCreator
    private static GraphQLRequest fromJson(@Nonnull @JsonProperty(value="query") String query, @Nullable @JsonProperty(value="operationName") String operationName, @Nullable @JsonProperty(value="variables") Map<String, Object> variables) {
        return new GraphQLRequest(query, operationName, variables);
    }

    public ExecutionInput toExecutionInput() {
        ExecutionInput.Builder executionInputBuilder = new ExecutionInput.Builder().query(this.query());
        if (this.operationName() != null) {
            executionInputBuilder.operationName(this.operationName());
        }
        if (this.variables() != null) {
            executionInputBuilder.variables(this.variables());
        }
        return executionInputBuilder.build();
    }
}

