/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLException;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.externalApi.exception.HttpExchangeException;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.io.GraphQLRequest;
import io.evitadb.externalApi.graphql.io.GraphQLResponse;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLHandler
implements HttpHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQLHandler.class);
    private static final String CONTENT_TYPE_CHARSET = "; charset=UTF-8";
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final AtomicReference<GraphQL> graphQL;

    public void handleRequest(@Nonnull HttpServerExchange exchange) throws Exception {
        GraphQLHandler.validateRequest(exchange);
        String body = GraphQLHandler.readRequestBody(exchange);
        GraphQLRequest graphQLRequest = this.parseRequest(body);
        ExecutionResult graphQLResponse = this.executeRequest(graphQLRequest);
        String serializedResult = this.serializeResult(GraphQLResponse.fromExecutionResult(graphQLResponse));
        GraphQLHandler.setSuccessResponse(exchange, serializedResult);
    }

    private static void validateRequest(@Nonnull HttpServerExchange exchange) {
        if (!GraphQLHandler.hasSupportedMethod(exchange)) {
            throw new HttpExchangeException(405, "Only POST method is currently supported.");
        }
        if (!GraphQLHandler.acceptsSupportedContentType(exchange)) {
            throw new HttpExchangeException(406, "Only supported result content types are those officially recommended by GraphQL Spec (`application/graphql+json`, `application/json`).");
        }
        if (!GraphQLHandler.bodyHasSupportedContentType(exchange)) {
            throw new HttpExchangeException(415, "Only supported request body content types are those officially recommended by GraphQL Spec (`application/graphql+json`, `application/json`).");
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    private static String readRequestBody(@Nonnull HttpServerExchange exchange) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    private GraphQLRequest parseRequest(@Nonnull String body) {
        try {
            return (GraphQLRequest)this.objectMapper.readValue(body, GraphQLRequest.class);
        }
        catch (IOException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof EvitaInternalError) {
                EvitaInternalError internalError = (EvitaInternalError)throwable;
                throw internalError;
            }
            throwable = e.getCause();
            if (throwable instanceof EvitaInvalidUsageException) {
                EvitaInvalidUsageException invalidUsageException = (EvitaInvalidUsageException)throwable;
                throw invalidUsageException;
            }
            throw new HttpExchangeException(415, "Invalid request body format. Expected JSON object.");
        }
    }

    @Nonnull
    private ExecutionResult executeRequest(@Nonnull GraphQLRequest graphQLRequest) {
        try {
            return this.graphQL.get().execute(graphQLRequest.toExecutionInput());
        }
        catch (GraphQLException e) {
            throw new GraphQLInternalError("Internal GraphQL API error: " + e.getMessage(), "Internal GraphQL API error.", e);
        }
    }

    @Nonnull
    private String serializeResult(@Nonnull GraphQLResponse<?> graphQLResponse) {
        String json;
        try {
            json = this.objectMapper.writeValueAsString(graphQLResponse);
        }
        catch (JsonProcessingException e) {
            throw new GraphQLInternalError("Could not serialize GraphQL API response to JSON: " + e.getMessage(), "Could not provide GraphQL API response.", e);
        }
        return json;
    }

    private static void setSuccessResponse(@Nonnull HttpServerExchange exchange, @Nonnull String data) {
        exchange.setStatusCode(200);
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, GraphQLHandler.getPreferredResponseContentType(exchange) + CONTENT_TYPE_CHARSET);
        exchange.getResponseSender().send(data);
    }

    @Nullable
    private static Stream<String> parseAcceptHeaders(@Nonnull HttpServerExchange exchange) {
        HeaderValues acceptHeaders = exchange.getRequestHeaders().get(Headers.ACCEPT);
        if (acceptHeaders == null) {
            return null;
        }
        return acceptHeaders.stream().flatMap(hv -> Arrays.stream(hv.split(","))).map(String::strip);
    }

    private static boolean bodyHasSupportedContentType(HttpServerExchange exchange) {
        String bodyContentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (bodyContentType == null) {
            return false;
        }
        return bodyContentType.startsWith("application/graphql+json") || bodyContentType.startsWith("application/json");
    }

    private static boolean acceptsSupportedContentType(@Nonnull HttpServerExchange exchange) {
        Stream<String> acceptHeaders = GraphQLHandler.parseAcceptHeaders(exchange);
        if (acceptHeaders == null) {
            return true;
        }
        return acceptHeaders.anyMatch(hv -> hv.equals("*/*") || hv.equals("application/graphql+json") || hv.equals("application/json"));
    }

    private static boolean hasSupportedMethod(@Nonnull HttpServerExchange exchange) {
        return exchange.getRequestMethod().equals(Methods.POST);
    }

    @Nonnull
    private static String getPreferredResponseContentType(@Nonnull HttpServerExchange exchange) {
        Stream<String> acceptHeaders = GraphQLHandler.parseAcceptHeaders(exchange);
        if (acceptHeaders == null) {
            return "application/graphql+json";
        }
        if (acceptHeaders.anyMatch(ah -> ah.equals("*/*") || ah.equals("application/graphql+json"))) {
            return "application/graphql+json";
        }
        return "application/json";
    }

    public GraphQLHandler(@Nonnull ObjectMapper objectMapper, @Nonnull AtomicReference<GraphQL> graphQL) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (graphQL == null) {
            throw new NullPointerException("graphQL is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.graphQL = graphQL;
    }

    private static /* synthetic */ Charset lambda$readRequestBody$2(String charsetName) {
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            throw new HttpExchangeException(415, "Unsupported charset.");
        }
    }

    private static /* synthetic */ String lambda$readRequestBody$1(String charsetPart) {
        String[] charsetParts = charsetPart.split("=");
        if (charsetParts.length != 2) {
            throw new HttpExchangeException(415, "Charset has invalid format");
        }
        return charsetParts[1].trim();
    }

    private static /* synthetic */ boolean lambda$readRequestBody$0(String part) {
        return part.startsWith("charset");
    }
}

