/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.evitadb.externalApi.configuration.AbstractApiConfiguration;
import io.evitadb.externalApi.configuration.ApiWithOriginControl;
import io.evitadb.externalApi.configuration.ApiWithSpecificPrefix;
import io.evitadb.utils.Assert;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GraphQLConfig
extends AbstractApiConfiguration
implements ApiWithSpecificPrefix,
ApiWithOriginControl {
    private static final String BASE_GRAPHQL_PATH = "gql";
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("([a-z]+)://([\\w.]+)(:(\\d+))?");
    private final String prefix;
    private final boolean parallelize;
    private final String[] allowedOrigins;

    public GraphQLConfig() {
        this.prefix = BASE_GRAPHQL_PATH;
        this.parallelize = true;
        this.allowedOrigins = null;
    }

    public GraphQLConfig(@Nonnull String host) {
        super(Boolean.valueOf(true), host);
        this.prefix = BASE_GRAPHQL_PATH;
        this.parallelize = true;
        this.allowedOrigins = null;
    }

    @JsonCreator
    public GraphQLConfig(@Nullable @JsonProperty(value="enabled") Boolean enabled, @Nonnull @JsonProperty(value="host") String host, @Nullable @JsonProperty(value="prefix") String prefix, @Nullable @JsonProperty(value="allowedOrigins") String allowedOrigins, @Nullable @JsonProperty(value="parallelize") Boolean parallelize) {
        super(enabled, host);
        this.prefix = Optional.ofNullable(prefix).orElse(BASE_GRAPHQL_PATH);
        this.parallelize = Optional.ofNullable(parallelize).orElse(false);
        this.allowedOrigins = allowedOrigins == null ? null : (String[])Arrays.stream(allowedOrigins.split(",")).peek(origin -> {
            Matcher matcher = ORIGIN_PATTERN.matcher((CharSequence)origin);
            Assert.isTrue((boolean)matcher.matches(), (String)("Invalid origin definition: " + origin));
        }).toArray(String[]::new);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isParallelize() {
        return this.parallelize;
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }
}

