/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver.dataFetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadDataFetcher<T>
implements DataFetcher<Object> {
    private static final Logger log = LoggerFactory.getLogger(ReadDataFetcher.class);
    @Nullable
    private final Executor executor;

    public Object get(DataFetchingEnvironment environment) throws Exception {
        if (this.executor == null) {
            log.debug("No executor for processing data fetcher `" + this.getClass().getName() + "`, processing synchronously.");
            return this.doGet(environment);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.doGet(environment);
            }
            catch (Throwable e) {
                log.error("DEBUG: Error occurred during async data fetcher call: ", e);
                throw e;
            }
        }, this.executor);
    }

    @Nonnull
    protected abstract T doGet(@Nonnull DataFetchingEnvironment var1);

    public ReadDataFetcher(@Nullable Executor executor) {
        this.executor = executor;
    }
}

