/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.resolver;

import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.SelectedField;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SelectionSetWrapper {
    private static final String TYPENAME_FIELD = "__typename";
    @Nonnull
    private final List<DataFetchingFieldSelectionSet> originalSelectionSets;
    @Nonnull
    private final Predicate<SelectedField> fieldPredicate;

    public static SelectionSetWrapper from(@Nonnull DataFetchingFieldSelectionSet originalSelectionSet) {
        return new SelectionSetWrapper(List.of(originalSelectionSet), field -> true);
    }

    public static SelectionSetWrapper from(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets) {
        return new SelectionSetWrapper(originalSelectionSets, field -> true);
    }

    public static SelectionSetWrapper from(@Nonnull DataFetchingFieldSelectionSet originalSelectionSet, @Nonnull String entityDtoObjectTypeName) {
        return new SelectionSetWrapper(List.of(originalSelectionSet), field -> field.getObjectTypeNames().contains(entityDtoObjectTypeName));
    }

    public static SelectionSetWrapper from(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets, @Nonnull String entityDtoObjectTypeName) {
        return new SelectionSetWrapper(originalSelectionSets, field -> field.getObjectTypeNames().contains(entityDtoObjectTypeName));
    }

    public boolean contains(@Nonnull String fieldGlobPattern) {
        return this.originalSelectionSets.stream().flatMap(ss -> ss.getFields(fieldGlobPattern, new String[0]).stream()).filter(f -> !f.getName().equals(TYPENAME_FIELD)).anyMatch(this.fieldPredicate);
    }

    public boolean containsAnyOf(@Nonnull String fieldGlobPattern, String ... fieldGlobPatterns) {
        return this.originalSelectionSets.stream().flatMap(ss -> ss.getFields(fieldGlobPattern, fieldGlobPatterns).stream()).filter(f -> !f.getName().equals(TYPENAME_FIELD)).anyMatch(this.fieldPredicate);
    }

    public List<SelectedField> getFields(@Nonnull String fieldGlobPattern, String ... fieldGlobPatterns) {
        return this.originalSelectionSets.stream().flatMap(ss -> ss.getFields(fieldGlobPattern, fieldGlobPatterns).stream()).filter(f -> !f.getName().equals(TYPENAME_FIELD)).filter(this.fieldPredicate).toList();
    }

    public boolean isEmpty() {
        return this.originalSelectionSets.isEmpty() || this.originalSelectionSets.stream().mapToLong(ss -> ss.getFields().size()).sum() == 0L;
    }

    private SelectionSetWrapper(@Nonnull List<DataFetchingFieldSelectionSet> originalSelectionSets, @Nonnull Predicate<SelectedField> fieldPredicate) {
        if (originalSelectionSets == null) {
            throw new NullPointerException("originalSelectionSets is marked non-null but is null");
        }
        if (fieldPredicate == null) {
            throw new NullPointerException("fieldPredicate is marked non-null but is null");
        }
        this.originalSelectionSets = originalSelectionSets;
        this.fieldPredicate = fieldPredicate;
    }
}

