/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.evitadb.dataType.BigDecimalNumberRange;
import io.evitadb.dataType.ByteNumberRange;
import io.evitadb.dataType.ComplexDataObject;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.IntegerNumberRange;
import io.evitadb.dataType.LongNumberRange;
import io.evitadb.dataType.ShortNumberRange;
import io.evitadb.externalApi.dataType.Any;
import io.evitadb.externalApi.dataType.GenericObject;
import io.evitadb.externalApi.graphql.api.dataType.GraphQLScalars;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class DataTypesConverter {
    @Nonnull
    private static final Map<Class<?>, GraphQLScalarType> SCALAR_MAPPINGS = CollectionUtils.createHashMap((int)32);

    public static <T extends GraphQLInputType & GraphQLOutputType> T getGraphQLScalarType(@Nonnull Class<?> javaDataType) {
        return DataTypesConverter.getGraphQLScalarType(javaDataType, false);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> T getGraphQLScalarType(@Nonnull Class<?> javaDataType, boolean nonNull) {
        Class<?> componentType = javaDataType.isArray() ? javaDataType.getComponentType() : javaDataType;
        GraphQLScalarType graphQLComponentType = componentType.isPrimitive() ? SCALAR_MAPPINGS.get(EvitaDataTypes.getWrappingPrimitiveClass(componentType)) : SCALAR_MAPPINGS.get(componentType);
        Assert.isPremiseValid((graphQLComponentType != null ? 1 : 0) != 0, () -> new GraphQLInternalError("Unsupported evitaDB data type in GraphQL API `" + javaDataType.getName() + "`."));
        return (T)DataTypesConverter.wrapGraphQLComponentType(graphQLComponentType, javaDataType, nonNull);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> T getGraphQLScalarType(@Nonnull Class<?> javaDataType, @Nonnull Class<?> replacementComponentType, boolean nonNull) {
        GraphQLScalarType graphQLComponentType = replacementComponentType.isPrimitive() ? SCALAR_MAPPINGS.get(EvitaDataTypes.getWrappingPrimitiveClass(replacementComponentType)) : SCALAR_MAPPINGS.get(replacementComponentType);
        Assert.isPremiseValid((graphQLComponentType != null ? 1 : 0) != 0, () -> new GraphQLInternalError("Unsupported evitaDB data type in GraphQL API `" + javaDataType.getName() + "`."));
        return (T)DataTypesConverter.wrapGraphQLComponentType(graphQLComponentType, javaDataType, nonNull);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> ConvertedEnum<T> getGraphQLEnumType(@Nonnull Class<?> javaEnumType) {
        return DataTypesConverter.getGraphQLEnumType(javaEnumType, false);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> ConvertedEnum<T> getGraphQLEnumType(@Nonnull Class<?> javaEnumType, boolean required) {
        Class<?> componentType = javaEnumType.isArray() ? javaEnumType.getComponentType() : javaEnumType;
        String enumName = componentType.getSimpleName();
        GraphQLEnumType.Builder graphQLEnumTypeBuilder = GraphQLEnumType.newEnum().name(enumName);
        for (Enum enumItem : (Enum[])componentType.getEnumConstants()) {
            graphQLEnumTypeBuilder.value(enumItem.name(), (Object)enumItem);
        }
        GraphQLEnumType graphQLEnumType = graphQLEnumTypeBuilder.build();
        GraphQLTypeReference graphQLType = DataTypesConverter.wrapGraphQLComponentType(GraphQLTypeReference.typeRef((String)enumName), javaEnumType, required);
        return new ConvertedEnum<GraphQLTypeReference>(graphQLType, graphQLEnumType);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> ConvertedEnum<T> getGraphQLEnumType(@Nonnull Class<?> javaEnumType, @Nonnull Class<?> replacementComponentType, boolean required) {
        Class<?> componentType = replacementComponentType;
        String enumName = componentType.getSimpleName();
        GraphQLEnumType.Builder graphQLEnumTypeBuilder = GraphQLEnumType.newEnum().name(enumName);
        for (Enum enumItem : (Enum[])componentType.getEnumConstants()) {
            graphQLEnumTypeBuilder.value(enumItem.name(), (Object)enumItem);
        }
        GraphQLEnumType graphQLEnumType = graphQLEnumTypeBuilder.build();
        GraphQLTypeReference graphQLType = DataTypesConverter.wrapGraphQLComponentType(GraphQLTypeReference.typeRef((String)enumName), javaEnumType, required);
        return new ConvertedEnum<GraphQLTypeReference>(graphQLType, graphQLEnumType);
    }

    public static <T extends GraphQLInputType & GraphQLOutputType> T wrapGraphQLComponentType(@Nonnull T convertedGraphQLComponentType, @Nonnull Class<?> javaDataType, boolean nonNull) {
        Object graphQLType = javaDataType.isArray() ? GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull(convertedGraphQLComponentType)) : convertedGraphQLComponentType;
        if (nonNull) {
            graphQLType = GraphQLNonNull.nonNull(graphQLType);
        }
        return graphQLType;
    }

    private DataTypesConverter() {
    }

    static {
        SCALAR_MAPPINGS.put(String.class, GraphQLScalars.STRING);
        SCALAR_MAPPINGS.put(Byte.class, GraphQLScalars.BYTE);
        SCALAR_MAPPINGS.put(Short.class, GraphQLScalars.SHORT);
        SCALAR_MAPPINGS.put(Integer.class, GraphQLScalars.INT);
        SCALAR_MAPPINGS.put(Long.class, GraphQLScalars.LONG);
        SCALAR_MAPPINGS.put(Boolean.class, GraphQLScalars.BOOLEAN);
        SCALAR_MAPPINGS.put(Character.class, GraphQLScalars.STRING);
        SCALAR_MAPPINGS.put(BigDecimal.class, GraphQLScalars.BIG_DECIMAL);
        SCALAR_MAPPINGS.put(OffsetDateTime.class, GraphQLScalars.OFFSET_DATE_TIME);
        SCALAR_MAPPINGS.put(LocalDateTime.class, GraphQLScalars.LOCAL_DATE_TIME);
        SCALAR_MAPPINGS.put(LocalDate.class, GraphQLScalars.LOCAL_DATE);
        SCALAR_MAPPINGS.put(LocalTime.class, GraphQLScalars.LOCAL_TIME);
        SCALAR_MAPPINGS.put(DateTimeRange.class, GraphQLScalars.DATE_TIME_RANGE);
        SCALAR_MAPPINGS.put(BigDecimalNumberRange.class, GraphQLScalars.BIG_DECIMAL_NUMBER_RANGE);
        SCALAR_MAPPINGS.put(ByteNumberRange.class, GraphQLScalars.BYTE_NUMBER_RANGE);
        SCALAR_MAPPINGS.put(ShortNumberRange.class, GraphQLScalars.SHORT_NUMBER_RANGE);
        SCALAR_MAPPINGS.put(IntegerNumberRange.class, GraphQLScalars.INTEGER_NUMBER_RANGE);
        SCALAR_MAPPINGS.put(LongNumberRange.class, GraphQLScalars.LONG_NUMBER_RANGE);
        SCALAR_MAPPINGS.put(ComplexDataObject.class, GraphQLScalars.COMPLEX_DATA_OBJECT);
        SCALAR_MAPPINGS.put(Locale.class, GraphQLScalars.LOCALE);
        SCALAR_MAPPINGS.put(Currency.class, GraphQLScalars.CURRENCY);
        SCALAR_MAPPINGS.put(Any.class, GraphQLScalars.ANY);
        SCALAR_MAPPINGS.put(GenericObject.class, GraphQLScalars.OBJECT);
    }

    public record ConvertedEnum<T extends GraphQLInputType & GraphQLOutputType>(@Nonnull T resultType, @Nonnull GraphQLEnumType enumType) {
    }
}

