/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.extraResult;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.LevelInfoDto;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.HierarchyRequireOutputNameResolver;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SpecificHierarchyDataFetcher
implements DataFetcher<List<LevelInfoDto>> {
    @Nonnull
    public List<LevelInfoDto> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        String outputName;
        Map hierarchiesOfReference = (Map)environment.getSource();
        List hierarchy = (List)hierarchiesOfReference.get(outputName = HierarchyRequireOutputNameResolver.resolve(environment.getField()));
        Assert.isPremiseValid((hierarchy != null ? 1 : 0) != 0, () -> new GraphQLQueryResolvingInternalError("Missing hierarchy for name `" + outputName + "`"));
        LinkedList<LevelInfoDto> flattenedHierarchy = new LinkedList<LevelInfoDto>();
        hierarchy.forEach(rootLevelInfo -> this.createLevelInfoDto((List<LevelInfoDto>)flattenedHierarchy, null, (Hierarchy.LevelInfo)rootLevelInfo, 1));
        return flattenedHierarchy;
    }

    private void createLevelInfoDto(@Nonnull List<LevelInfoDto> flattenedHierarchy, @Nullable Hierarchy.LevelInfo parentLevelInfo, @Nonnull Hierarchy.LevelInfo levelInfo, int currentLevel) {
        LevelInfoDto currentLevelInfoDto = new LevelInfoDto(parentLevelInfo != null ? parentLevelInfo.entity().getPrimaryKey() : null, currentLevel, levelInfo.entity(), levelInfo.queriedEntityCount(), levelInfo.childrenCount(), !levelInfo.children().isEmpty());
        flattenedHierarchy.add(currentLevelInfoDto);
        levelInfo.children().forEach(childLevelInfo -> this.createLevelInfoDto(flattenedHierarchy, levelInfo, (Hierarchy.LevelInfo)childLevelInfo, currentLevel + 1));
    }
}

