/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.PriceContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PriceDataFetcher
implements DataFetcher<DataFetcherResult<PriceContract>> {
    @Nonnull
    public DataFetcherResult<PriceContract> get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        String priceList = (String)environment.getArgument(PriceFieldHeaderDescriptor.PRICE_LIST.name());
        Currency customCurrency = (Currency)environment.getArgument(PriceFieldHeaderDescriptor.CURRENCY.name());
        EntityQueryContext context = (EntityQueryContext)environment.getLocalContext();
        EntityDecorator entity = (EntityDecorator)environment.getSource();
        Currency currency = Optional.ofNullable(customCurrency).or(() -> Optional.ofNullable(context.getDesiredPriceInCurrency())).orElseThrow(() -> new GraphQLInvalidArgumentException("Missing `currency` argument. You can use `" + PriceFieldHeaderDescriptor.CURRENCY.name() + "` parameter for specifying custom currency."));
        Collection possiblePrices = entity.getPrices(currency, priceList);
        PriceContract pickedPrice = null;
        if (possiblePrices.size() == 1) {
            pickedPrice = (PriceContract)possiblePrices.iterator().next();
        } else if (possiblePrices.size() > 1) {
            OffsetDateTime priceValidIn = Optional.ofNullable(context.getDesiredPriceValidIn()).orElse(entity.getAlignedNow());
            pickedPrice = possiblePrices.stream().filter(p -> p.getValidity() == null || p.isValid(priceValidIn)).findFirst().orElse(null);
        }
        Locale customLocale = (Locale)environment.getArgument(PriceFieldHeaderDescriptor.LOCALE.name());
        EntityQueryContext newContext = context.toBuilder().desiredLocale(customLocale != null ? customLocale : context.getDesiredLocale()).build();
        return DataFetcherResult.newResult().data((Object)pickedPrice).localContext((Object)newContext).build();
    }
}

