/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.TypeResolver;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class EntityDtoTypeResolver
implements TypeResolver {
    private final Map<String, GraphQLObjectType> entityTypeToEntityDtoMapping;

    @Nonnull
    public GraphQLObjectType getType(@Nonnull TypeResolutionEnvironment env) {
        EntityClassifier entity = (EntityClassifier)env.getObject();
        return Optional.ofNullable(this.entityTypeToEntityDtoMapping.get(entity.getType())).orElseThrow(() -> new GraphQLQueryResolvingInternalError("Missing entity dto for entity type `" + entity.getType() + "`."));
    }

    public EntityDtoTypeResolver(Map<String, GraphQLObjectType> entityTypeToEntityDtoMapping) {
        this.entityTypeToEntityDtoMapping = entityTypeToEntityDtoMapping;
    }
}

