/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.requestResponse.data.AssociatedDataContract;
import io.evitadb.api.requestResponse.schema.AssociatedDataSchemaContract;
import io.evitadb.dataType.ComplexDataObject;
import io.evitadb.dataType.data.ComplexDataObjectToJsonConverter;
import io.evitadb.dataType.data.DataItemVisitor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssociatedDataValueDataFetcher<T extends Serializable>
implements DataFetcher<T> {
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final AssociatedDataSchemaContract associatedDataSchema;

    @Nullable
    public T get(@Nonnull DataFetchingEnvironment environment) throws Exception {
        AssociatedDataContract associatedData = (AssociatedDataContract)environment.getSource();
        Locale locale = ((EntityQueryContext)environment.getLocalContext()).getDesiredLocale();
        if (locale == null && this.associatedDataSchema.isLocalized()) {
            throw new GraphQLInvalidArgumentException("Associated data '" + this.associatedDataSchema.getName() + "' is localized, yet no locale for associated data was specified.");
        }
        Serializable associatedDataValue = locale == null ? associatedData.getAssociatedData(this.associatedDataSchema.getName()) : associatedData.getAssociatedData(this.associatedDataSchema.getName(), locale);
        if (associatedDataValue == null) {
            return null;
        }
        if (!(associatedDataValue instanceof ComplexDataObject)) {
            return (T)associatedDataValue;
        }
        return (T)((Serializable)this.convertComplexDataObjectToJson((ComplexDataObject)associatedDataValue));
    }

    private JsonNode convertComplexDataObjectToJson(@Nonnull ComplexDataObject associatedDataValue) {
        ComplexDataObjectToJsonConverter converter = new ComplexDataObjectToJsonConverter(this.objectMapper);
        associatedDataValue.accept((DataItemVisitor)converter);
        return converter.getRootNode();
    }

    public AssociatedDataValueDataFetcher(@Nonnull ObjectMapper objectMapper, @Nonnull AssociatedDataSchemaContract associatedDataSchema) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (associatedDataSchema == null) {
            throw new NullPointerException("associatedDataSchema is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.associatedDataSchema = associatedDataSchema;
    }
}

