/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.AttributeInSet;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ListUnknownEntitiesQueryHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetWrapper;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnknownEntitiesDataFetcher
extends ReadDataFetcher<DataFetcherResult<List<EntityClassifier>>> {
    private static final Logger log = LoggerFactory.getLogger(ListUnknownEntitiesDataFetcher.class);
    @Nonnull
    private final CatalogSchemaContract catalogSchema;
    @Nonnull
    private final Function<String, EntitySchemaContract> entitySchemaFetcher;
    @Nonnull
    private final Map<String, String> entityDtoObjectTypeNameByEntityType;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public ListUnknownEntitiesDataFetcher(@Nullable Executor executor, @Nonnull CatalogSchemaContract catalogSchema, @Nonnull Set<EntitySchemaContract> allEntitySchemas) {
        super(executor);
        this.catalogSchema = catalogSchema;
        this.entitySchemaFetcher = arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0);
        this.entityDtoObjectTypeNameByEntityType = CollectionUtils.createHashMap((int)allEntitySchemas.size());
        allEntitySchemas.forEach(entitySchema -> this.entityDtoObjectTypeNameByEntityType.put(entitySchema.getName(), entitySchema.getNameVariant(ExternalApiNamingConventions.TYPE_NAME_NAMING_CONVENTION)));
        FilterConstraintResolver filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        OrderConstraintResolver orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), filterConstraintResolver, orderConstraintResolver, requireConstraintResolver);
    }

    @Override
    @Nonnull
    public DataFetcherResult<List<EntityClassifier>> doGet(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment, this.catalogSchema);
        FilterBy filterBy = this.buildFilterBy(arguments);
        Require require = this.buildRequire(arguments);
        Query query = Query.query((FilterBy)filterBy, (Require)require);
        log.debug("Generated evitaDB query for single unknown entity fetch `{}`.", (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        List entityReferences = evitaSession.queryList(query, SealedEntity.class);
        List<Object> loadedEntities = entityReferences.isEmpty() ? List.of() : entityReferences.stream().map(entityReference -> {
            String entityType = entityReference.getType();
            Object[] contentRequires = this.buildEnrichingRequires(environment, entityType);
            log.debug("Enriching entity reference `{}` with `{}`.", entityReference, (Object)Arrays.toString(contentRequires));
            return evitaSession.enrichEntity(entityReference, (EntityContentRequire[])contentRequires);
        }).toList();
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().data(loadedEntities);
        if (!loadedEntities.isEmpty()) {
            resultBuilder.localContext((Object)EntityQueryContext.builder().build());
        }
        return resultBuilder.build();
    }

    @Nonnull
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        LinkedList<AttributeInSet> filterConstraints = new LinkedList<AttributeInSet>();
        for (Map.Entry<GlobalAttributeSchemaContract, List<Object>> attribute : arguments.globallyUniqueAttributes().entrySet()) {
            GlobalAttributeSchemaContract attributeSchema = attribute.getKey();
            Serializable[] attributeValues = (Serializable[])attribute.getValue().toArray(size -> (Serializable[])Array.newInstance(attributeSchema.getPlainType(), size));
            filterConstraints.add(QueryConstraints.attributeInSet((String)attributeSchema.getName(), (Serializable[])attributeValues));
        }
        return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
    }

    @Nonnull
    private Require buildRequire(@Nonnull Arguments arguments) {
        LinkedList<Object> requireConstraints = new LinkedList<Object>();
        requireConstraints.add(QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0]));
        if (arguments.limit() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)0, (Integer)arguments.limit()));
        }
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    @Nonnull
    private EntityContentRequire[] buildEnrichingRequires(@Nonnull DataFetchingEnvironment environment, @Nonnull String entityType) {
        Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetWrapper.from(environment.getSelectionSet(), this.entityDtoObjectTypeNameByEntityType.get(entityType)), null, this.entitySchemaFetcher.apply(entityType));
        return entityFetch.map(EntityFetch::getRequirements).orElse(new EntityContentRequire[0]);
    }

    private record Arguments(@Nullable Integer limit, @Nonnull Map<GlobalAttributeSchemaContract, List<Object>> globallyUniqueAttributes) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment, @Nonnull CatalogSchemaContract catalogSchema) {
            HashMap<String, Object> arguments = new HashMap<String, Object>(environment.getArguments());
            Integer limit = (Integer)arguments.remove(ListUnknownEntitiesQueryHeaderDescriptor.LIMIT.name());
            Map<GlobalAttributeSchemaContract, List<Object>> globallyUniqueAttributes = Arguments.extractUniqueAttributesFromArguments(arguments, catalogSchema);
            if (globallyUniqueAttributes.isEmpty()) {
                throw new GraphQLInvalidArgumentException("Missing globally unique attribute to identify entity.");
            }
            return new Arguments(limit, globallyUniqueAttributes);
        }

        private static Map<GlobalAttributeSchemaContract, List<Object>> extractUniqueAttributesFromArguments(@Nonnull HashMap<String, Object> arguments, @Nonnull CatalogSchemaContract catalogSchema) {
            HashMap uniqueAttributes = CollectionUtils.createHashMap((int)arguments.size());
            for (Map.Entry<String, Object> argument : arguments.entrySet()) {
                String attributeName = argument.getKey();
                GlobalAttributeSchemaContract attributeSchema = catalogSchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
                if (attributeSchema == null) continue;
                Assert.isPremiseValid((boolean)attributeSchema.isUniqueGlobally(), () -> new GraphQLQueryResolvingInternalError("Cannot filter list of entities by non-unique attribute `" + attributeName + "`."));
                List attributeValues = (List)argument.getValue();
                if (attributeValues == null || attributeValues.isEmpty()) continue;
                uniqueAttributes.put(attributeSchema, attributeValues);
            }
            return uniqueAttributes;
        }
    }
}

