/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint;

import graphql.schema.SelectedField;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.AssociatedDataContent;
import io.evitadb.api.query.require.AttributeContent;
import io.evitadb.api.query.require.DataInLocales;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.EntityGroupFetch;
import io.evitadb.api.query.require.HierarchyContent;
import io.evitadb.api.query.require.HierarchyStopAt;
import io.evitadb.api.query.require.PriceContent;
import io.evitadb.api.query.require.PriceContentMode;
import io.evitadb.api.query.require.ReferenceContent;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.HierarchyDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ReferenceDataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.GraphQLEntityDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AssociatedDataFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.AttributesFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ParentsFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PriceForSaleFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.PricesFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.entity.ReferenceFieldHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetWrapper;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidArgumentException;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidResponseUsageException;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityFetchRequireResolver {
    @Nonnull
    private final Function<String, EntitySchemaContract> entitySchemaFetcher;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;

    @Nonnull
    public Optional<EntityFetch> resolveEntityFetch(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        return this.resolveContentRequirements(selectionSetWrapper, desiredLocale, currentEntitySchema).map(it -> QueryConstraints.entityFetch((EntityContentRequire[])((EntityContentRequire[])it.toArray(EntityContentRequire[]::new))));
    }

    @Nonnull
    public Optional<EntityGroupFetch> resolveGroupFetch(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        return this.resolveContentRequirements(selectionSetWrapper, desiredLocale, currentEntitySchema).map(it -> QueryConstraints.entityGroupFetch((EntityContentRequire[])((EntityContentRequire[])it.toArray(EntityContentRequire[]::new))));
    }

    @Nonnull
    private Optional<List<EntityContentRequire>> resolveContentRequirements(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nullable EntitySchemaContract currentEntitySchema) {
        if (currentEntitySchema == null) {
            return Optional.empty();
        }
        if (!this.needsEntityBody(selectionSetWrapper, currentEntitySchema)) {
            return Optional.empty();
        }
        LinkedList<ReferenceContent> entityContentRequires = new LinkedList<ReferenceContent>();
        this.resolveHierarchyContent(selectionSetWrapper, desiredLocale, currentEntitySchema).ifPresent(entityContentRequires::add);
        this.resolveAttributeContent(selectionSetWrapper, currentEntitySchema).ifPresent(entityContentRequires::add);
        this.resolveAssociatedDataContent(selectionSetWrapper, currentEntitySchema).ifPresent(entityContentRequires::add);
        this.resolvePriceContent(selectionSetWrapper).ifPresent(entityContentRequires::add);
        entityContentRequires.addAll(this.resolveReferenceContent(selectionSetWrapper, desiredLocale, currentEntitySchema));
        this.resolveDataInLocales(selectionSetWrapper, desiredLocale, currentEntitySchema).ifPresent(entityContentRequires::add);
        return Optional.of(entityContentRequires);
    }

    private boolean needsEntityBody(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nonnull EntitySchemaContract currentEntitySchema) {
        return this.needsParent(selectionSetWrapper) || this.needsParents(selectionSetWrapper) || this.needsLocales(selectionSetWrapper) || this.needsAttributes(selectionSetWrapper) || this.needsAssociatedData(selectionSetWrapper) || this.needsPrices(selectionSetWrapper) || this.needsReferences(selectionSetWrapper, currentEntitySchema);
    }

    private boolean needsParent(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.PARENT_PRIMARY_KEY.name());
    }

    private boolean needsParents(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.PARENTS.name());
    }

    private boolean needsLocales(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.LOCALES.name()) || selectionSetWrapper.contains(GraphQLEntityDescriptor.ALL_LOCALES.name());
    }

    private boolean needsAttributes(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.ATTRIBUTES.name());
    }

    private boolean needsAssociatedData(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.ASSOCIATED_DATA.name());
    }

    private boolean needsPrices(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        return selectionSetWrapper.contains(GraphQLEntityDescriptor.PRICE.name() + "*");
    }

    private boolean needsReferences(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nonnull EntitySchemaContract currentEntitySchema) {
        return currentEntitySchema.getReferences().values().stream().map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).anyMatch(selectionSetWrapper::contains);
    }

    @Nonnull
    private Optional<HierarchyContent> resolveHierarchyContent(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!this.needsParents(selectionSetWrapper)) {
            return Optional.empty();
        }
        List<SelectedField> parentsFields = selectionSetWrapper.getFields(GraphQLEntityDescriptor.PARENTS.name(), new String[0]);
        Assert.isTrue((parentsFields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidResponseUsageException("Only one `" + GraphQLEntityDescriptor.PARENTS.name() + "` field is supported."));
        return parentsFields.stream().findFirst().map(parentsField -> {
            HierarchyDataLocator hierarchyDataLocator = new HierarchyDataLocator(currentEntitySchema.getName());
            HierarchyStopAt stopAt = Optional.ofNullable(parentsField.getArguments().get(ParentsFieldHeaderDescriptor.STOP_AT.name())).map(arg_0 -> this.lambda$resolveHierarchyContent$6((DataLocator)hierarchyDataLocator, arg_0)).orElse(null);
            EntityFetch entityFetch = this.resolveEntityFetch(SelectionSetWrapper.from(parentsField.getSelectionSet()), desiredLocale, currentEntitySchema).orElse(null);
            return QueryConstraints.hierarchyContent((HierarchyStopAt)stopAt, (EntityFetch)entityFetch);
        });
    }

    @Nonnull
    private Optional<AttributeContent> resolveAttributeContent(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!this.needsAttributes(selectionSetWrapper)) {
            return Optional.empty();
        }
        String[] neededAttributes = (String[])selectionSetWrapper.getFields(GraphQLEntityDescriptor.ATTRIBUTES.name(), new String[0]).stream().flatMap(f -> SelectionSetWrapper.from(f.getSelectionSet()).getFields("*", new String[0]).stream()).map(f -> currentEntitySchema.getAttributeByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).filter(Optional::isPresent).map(Optional::get).map(NamedSchemaContract::getName).collect(Collectors.toUnmodifiableSet()).toArray(String[]::new);
        if (neededAttributes.length == 0) {
            return Optional.empty();
        }
        return Optional.of(QueryConstraints.attributeContent((String[])neededAttributes));
    }

    @Nonnull
    private Optional<AssociatedDataContent> resolveAssociatedDataContent(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!this.needsAssociatedData(selectionSetWrapper)) {
            return Optional.empty();
        }
        String[] neededAssociatedData = (String[])selectionSetWrapper.getFields(GraphQLEntityDescriptor.ASSOCIATED_DATA.name(), new String[0]).stream().flatMap(f -> SelectionSetWrapper.from(f.getSelectionSet()).getFields("*", new String[0]).stream()).map(f -> currentEntitySchema.getAssociatedDataByName(f.getName(), ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).filter(Optional::isPresent).map(Optional::get).map(NamedSchemaContract::getName).collect(Collectors.toUnmodifiableSet()).toArray(String[]::new);
        if (neededAssociatedData.length == 0) {
            return Optional.empty();
        }
        return Optional.of(QueryConstraints.associatedDataContent((String[])neededAssociatedData));
    }

    @Nonnull
    private Optional<PriceContent> resolvePriceContent(@Nonnull SelectionSetWrapper selectionSetWrapper) {
        if (!this.needsPrices(selectionSetWrapper)) {
            return Optional.empty();
        }
        if (selectionSetWrapper.getFields(GraphQLEntityDescriptor.PRICES.name(), new String[0]).stream().anyMatch(f -> f.getArguments().get(PricesFieldHeaderDescriptor.PRICE_LISTS.name()) == null)) {
            return Optional.of(QueryConstraints.priceContentAll());
        }
        HashSet neededPriceLists = CollectionUtils.createHashSet((int)10);
        neededPriceLists.addAll(selectionSetWrapper.getFields(GraphQLEntityDescriptor.PRICE_FOR_SALE.name(), new String[0]).stream().map(f -> (String)f.getArguments().get(PriceForSaleFieldHeaderDescriptor.PRICE_LIST.name())).filter(Objects::nonNull).collect(Collectors.toSet()));
        neededPriceLists.addAll(selectionSetWrapper.getFields(GraphQLEntityDescriptor.PRICE.name(), new String[0]).stream().map(f -> (String)f.getArguments().get(PriceFieldHeaderDescriptor.PRICE_LIST.name())).collect(Collectors.toSet()));
        neededPriceLists.addAll(selectionSetWrapper.getFields(GraphQLEntityDescriptor.PRICES.name(), new String[0]).stream().flatMap(f -> ((List)f.getArguments().get(PricesFieldHeaderDescriptor.PRICE_LISTS.name())).stream()).collect(Collectors.toSet()));
        return Optional.of(QueryConstraints.priceContent((PriceContentMode)PriceContentMode.RESPECTING_FILTER, (String[])((String[])neededPriceLists.toArray(String[]::new))));
    }

    @Nonnull
    private List<ReferenceContent> resolveReferenceContent(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!this.needsReferences(selectionSetWrapper, currentEntitySchema)) {
            return List.of();
        }
        return currentEntitySchema.getReferences().values().stream().map(it -> new FieldsForReferenceHolder((ReferenceSchemaContract)it, selectionSetWrapper.getFields(it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION), new String[0]))).filter(it -> !it.fields().isEmpty()).map(it -> new RequirementForReferenceHolder(it.referenceSchema(), this.resolveReferenceContentFilter(currentEntitySchema, (FieldsForReferenceHolder)it).orElse(null), this.resolveReferenceContentOrder(currentEntitySchema, (FieldsForReferenceHolder)it).orElse(null), this.resolveReferenceEntityRequirement(desiredLocale, (FieldsForReferenceHolder)it).orElse(null), this.resolveReferenceGroupRequirement(desiredLocale, (FieldsForReferenceHolder)it).orElse(null))).map(it -> QueryConstraints.referenceContent((String)it.referenceSchema().getName(), (FilterBy)it.filterBy(), (OrderBy)it.orderBy(), (EntityFetch)it.entityRequirement(), (EntityGroupFetch)it.groupRequirement())).toList();
    }

    @Nonnull
    private Optional<FilterBy> resolveReferenceContentFilter(@Nonnull EntitySchemaContract currentEntitySchema, @Nonnull FieldsForReferenceHolder fieldsForReferenceHolder) {
        List<SelectedField> fields = fieldsForReferenceHolder.fields();
        boolean someFieldHasFilter = fields.stream().anyMatch(it -> it.getArguments().containsKey(ReferenceFieldHeaderDescriptor.FILTER_BY.name()));
        if (!someFieldHasFilter) {
            return Optional.empty();
        }
        Assert.isTrue((fields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidArgumentException("Reference filtering is currently supported only if there is only one reference of particular name requested."));
        return Optional.ofNullable((FilterBy)this.filterConstraintResolver.resolve((DataLocator)new ReferenceDataLocator(currentEntitySchema.getName(), fieldsForReferenceHolder.referenceSchema().getName()), ReferenceFieldHeaderDescriptor.FILTER_BY.name(), fields.get(0).getArguments().get(ReferenceFieldHeaderDescriptor.FILTER_BY.name())));
    }

    @Nonnull
    private Optional<OrderBy> resolveReferenceContentOrder(@Nonnull EntitySchemaContract currentEntitySchema, @Nonnull FieldsForReferenceHolder fieldsForReferenceHolder) {
        List<SelectedField> fields = fieldsForReferenceHolder.fields();
        boolean someFieldHasFilter = fields.stream().anyMatch(it -> it.getArguments().containsKey(ReferenceFieldHeaderDescriptor.ORDER_BY.name()));
        if (!someFieldHasFilter) {
            return Optional.empty();
        }
        Assert.isTrue((fields.size() <= 1 ? 1 : 0) != 0, () -> new GraphQLInvalidArgumentException("Reference ordering is currently supported only if there is only one reference of particular name requested."));
        return Optional.ofNullable((OrderBy)this.orderConstraintResolver.resolve((DataLocator)new ReferenceDataLocator(currentEntitySchema.getName(), fieldsForReferenceHolder.referenceSchema().getName()), ReferenceFieldHeaderDescriptor.ORDER_BY.name(), fieldsForReferenceHolder.fields().get(0).getArguments().get(ReferenceFieldHeaderDescriptor.ORDER_BY.name())));
    }

    @Nonnull
    private Optional<EntityFetch> resolveReferenceEntityRequirement(@Nullable Locale desiredLocale, @Nonnull FieldsForReferenceHolder fieldsForReference) {
        EntitySchemaContract referencedEntitySchema;
        SelectionSetWrapper referencedEntitySelectionSet = SelectionSetWrapper.from(fieldsForReference.fields().stream().flatMap(it2 -> it2.getSelectionSet().getFields(ReferenceDescriptor.REFERENCED_ENTITY.name(), new String[0]).stream()).map(SelectedField::getSelectionSet).toList());
        Optional<EntityFetch> referencedEntityRequirement = this.resolveEntityFetch(referencedEntitySelectionSet, desiredLocale, referencedEntitySchema = fieldsForReference.referenceSchema().isReferencedEntityTypeManaged() ? this.entitySchemaFetcher.apply(fieldsForReference.referenceSchema().getReferencedEntityType()) : null);
        if (referencedEntityRequirement.isEmpty() && !referencedEntitySelectionSet.isEmpty()) {
            return Optional.of(QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0]));
        }
        return referencedEntityRequirement;
    }

    @Nonnull
    private Optional<EntityGroupFetch> resolveReferenceGroupRequirement(@Nullable Locale desiredLocale, @Nonnull FieldsForReferenceHolder fieldsForReference) {
        SelectionSetWrapper referencedGroupSelectionSet = SelectionSetWrapper.from(fieldsForReference.fields().stream().flatMap(it2 -> it2.getSelectionSet().getFields(ReferenceDescriptor.GROUP_ENTITY.name(), new String[0]).stream()).map(SelectedField::getSelectionSet).toList());
        EntitySchemaContract referencedEntitySchema = fieldsForReference.referenceSchema().isReferencedGroupTypeManaged() ? this.entitySchemaFetcher.apply(fieldsForReference.referenceSchema().getReferencedGroupType()) : null;
        return this.resolveGroupFetch(referencedGroupSelectionSet, desiredLocale, referencedEntitySchema);
    }

    @Nonnull
    private Optional<DataInLocales> resolveDataInLocales(@Nonnull SelectionSetWrapper selectionSetWrapper, @Nullable Locale desiredLocale, @Nonnull EntitySchemaContract currentEntitySchema) {
        if (!this.needsAttributes(selectionSetWrapper) && !this.needsAssociatedData(selectionSetWrapper)) {
            return Optional.empty();
        }
        HashSet neededLocales = CollectionUtils.createHashSet((int)currentEntitySchema.getLocales().size());
        if (desiredLocale != null) {
            neededLocales.add(desiredLocale);
        }
        neededLocales.addAll(selectionSetWrapper.getFields(GraphQLEntityDescriptor.ATTRIBUTES.name(), new String[0]).stream().map(f -> (Locale)f.getArguments().get(AttributesFieldHeaderDescriptor.LOCALE.name())).filter(Objects::nonNull).collect(Collectors.toSet()));
        neededLocales.addAll(selectionSetWrapper.getFields(GraphQLEntityDescriptor.ASSOCIATED_DATA.name(), new String[0]).stream().map(f -> (Locale)f.getArguments().get(AssociatedDataFieldHeaderDescriptor.LOCALE.name())).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (neededLocales.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(QueryConstraints.dataInLocales((Locale[])((Locale[])neededLocales.toArray(Locale[]::new))));
    }

    public EntityFetchRequireResolver(@Nonnull Function<String, EntitySchemaContract> entitySchemaFetcher, @Nonnull FilterConstraintResolver filterConstraintResolver, @Nonnull OrderConstraintResolver orderConstraintResolver, @Nonnull RequireConstraintResolver requireConstraintResolver) {
        if (entitySchemaFetcher == null) {
            throw new NullPointerException("entitySchemaFetcher is marked non-null but is null");
        }
        if (filterConstraintResolver == null) {
            throw new NullPointerException("filterConstraintResolver is marked non-null but is null");
        }
        if (orderConstraintResolver == null) {
            throw new NullPointerException("orderConstraintResolver is marked non-null but is null");
        }
        if (requireConstraintResolver == null) {
            throw new NullPointerException("requireConstraintResolver is marked non-null but is null");
        }
        this.entitySchemaFetcher = entitySchemaFetcher;
        this.filterConstraintResolver = filterConstraintResolver;
        this.orderConstraintResolver = orderConstraintResolver;
        this.requireConstraintResolver = requireConstraintResolver;
    }

    private /* synthetic */ HierarchyStopAt lambda$resolveHierarchyContent$6(DataLocator hierarchyDataLocator, Object it) {
        return (HierarchyStopAt)this.requireConstraintResolver.resolve(hierarchyDataLocator, hierarchyDataLocator, ParentsFieldHeaderDescriptor.STOP_AT.name(), it);
    }

    private record FieldsForReferenceHolder(@Nonnull ReferenceSchemaContract referenceSchema, @Nonnull List<SelectedField> fields) {
    }

    private record RequirementForReferenceHolder(@Nonnull ReferenceSchemaContract referenceSchema, @Nullable FilterBy filterBy, @Nullable OrderBy orderBy, @Nullable EntityFetch entityRequirement, @Nullable EntityGroupFetch groupRequirement) {
    }
}

