/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.builder;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.core.Evita;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.externalApi.graphql.api.builder.GraphQLSchemaBuildingContext;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class CatalogGraphQLSchemaBuildingContext
extends GraphQLSchemaBuildingContext {
    @Nonnull
    private final CatalogContract catalog;
    @Nonnull
    private final Set<EntitySchemaContract> entitySchemas;
    @Nonnull
    private final Map<String, GraphQLObjectType> entityTypeToEntityObject = CollectionUtils.createHashMap((int)50);

    public CatalogGraphQLSchemaBuildingContext(@Nonnull GraphQLConfig config, @Nonnull Evita evita, @Nonnull CatalogContract catalog) {
        super(config, evita);
        this.catalog = catalog;
        this.entitySchemas = (Set)evita.queryCatalog(catalog.getName(), session -> {
            Set collections = session.getAllEntityTypes();
            HashSet schemas = CollectionUtils.createHashSet((int)collections.size());
            collections.forEach(c -> schemas.add((EntitySchemaContract)session.getEntitySchema(c).orElseThrow(() -> new EvitaInternalError("Entity `" + c + "` schema unexpectedly not found!"))));
            return schemas;
        }, new SessionTraits.SessionFlags[0]);
    }

    @Nonnull
    public CatalogSchemaContract getSchema() {
        return this.catalog.getSchema();
    }

    public void registerEntityObject(@Nonnull String entityType, @Nonnull GraphQLObjectType entityObject) {
        this.registerType((GraphQLType)entityObject);
        this.entityTypeToEntityObject.putIfAbsent(entityType, entityObject);
    }

    @Nonnull
    public CatalogContract getCatalog() {
        return this.catalog;
    }

    @Nonnull
    public Set<EntitySchemaContract> getEntitySchemas() {
        return this.entitySchemas;
    }

    @Nonnull
    public Map<String, GraphQLObjectType> getEntityTypeToEntityObject() {
        return this.entityTypeToEntityObject;
    }
}

