/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import graphql.ExecutionResult;
import graphql.execution.ExecutionContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.OperationDefinition;
import io.evitadb.api.EvitaContract;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.exception.GraphQLSchemaBuildingError;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EvitaSessionManagingInstrumentation
extends SimpleInstrumentation {
    @Nonnull
    private final EvitaContract evita;
    @Nonnull
    private final String catalogName;

    @Nonnull
    public ExecutionContext instrumentExecutionContext(@Nonnull ExecutionContext executionContext, @Nonnull InstrumentationExecutionParameters parameters, @Nonnull InstrumentationState state) {
        EvitaSessionContract evitaSession;
        OperationDefinition.Operation operation = executionContext.getOperationDefinition().getOperation();
        if (operation == OperationDefinition.Operation.QUERY) {
            evitaSession = this.evita.createReadOnlySession(this.catalogName);
        } else if (operation == OperationDefinition.Operation.MUTATION) {
            evitaSession = this.evita.createReadWriteSession(this.catalogName);
            evitaSession.openTransaction();
        } else {
            throw new GraphQLSchemaBuildingError("Operation `" + operation + "` is currently not supported by evitaDB GraphQL API.");
        }
        executionContext.getGraphQLContext().put((Object)GraphQLContextKey.EVITA_SESSION, (Object)evitaSession);
        return executionContext;
    }

    @Nonnull
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(@Nonnull ExecutionResult executionResult, @Nonnull InstrumentationExecutionParameters parameters, @Nonnull InstrumentationState state) {
        EvitaSessionContract evitaSession = (EvitaSessionContract)parameters.getGraphQLContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        if (evitaSession != null) {
            if (evitaSession.isTransactionOpen()) {
                evitaSession.closeTransaction();
            }
            evitaSession.close();
        }
        return CompletableFuture.completedFuture(executionResult);
    }

    public EvitaSessionManagingInstrumentation(@Nonnull EvitaContract evita, @Nonnull String catalogName) {
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked non-null but is null");
        }
        this.evita = evita;
        this.catalogName = catalogName;
    }
}

