/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.graphql.GraphQLManager;
import io.evitadb.externalApi.graphql.GraphQLProvider;
import io.evitadb.externalApi.graphql.api.catalog.CatalogGraphQLRefreshingObserver;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderRegistrar;
import io.undertow.server.HttpHandler;
import javax.annotation.Nonnull;

public class GraphQLProviderRegistrar
implements ExternalApiProviderRegistrar<GraphQLConfig> {
    @Nonnull
    public String getExternalApiCode() {
        return "graphQL";
    }

    @Nonnull
    public Class<GraphQLConfig> getConfigurationClass() {
        return GraphQLConfig.class;
    }

    @Nonnull
    public ExternalApiProvider<GraphQLConfig> register(@Nonnull Evita evita, @Nonnull ApiOptions apiOptions, @Nonnull GraphQLConfig graphQLConfig) {
        GraphQLManager graphQLManager = new GraphQLManager(graphQLConfig, evita);
        evita.registerStructuralChangeObserver((CatalogStructuralChangeObserver)new CatalogGraphQLRefreshingObserver(graphQLManager));
        HttpHandler apiHandler = graphQLManager.getGraphQLRouter();
        return new GraphQLProvider(graphQLConfig, apiHandler);
    }
}

