/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.io;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.graphql.exception.GraphQLInternalError;
import io.evitadb.externalApi.graphql.exception.GraphQLInvalidUsageException;
import io.evitadb.externalApi.http.EndpointExchange;
import io.evitadb.externalApi.http.EndpointHandler;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.undertow.server.HttpServerExchange;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaHandler
extends EndpointHandler<GraphQLEndpointExchange> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaHandler.class);
    private static final Set<String> IMPLICIT_DIRECTIVES = Set.of("deprecated", "skip", "include", "specifiedBy");
    @Nonnull
    private final SchemaPrinter schemaPrinter = new SchemaPrinter(SchemaPrinter.Options.defaultOptions().includeDirectives(directive -> !IMPLICIT_DIRECTIVES.contains(directive)));
    @Nonnull
    private final AtomicReference<GraphQL> graphQL;

    public GraphQLSchemaHandler(@Nonnull AtomicReference<GraphQL> graphQL) {
        this.graphQL = graphQL;
    }

    @Nonnull
    protected GraphQLEndpointExchange createEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyMediaType, @Nullable String preferredResponseMediaType) {
        return new GraphQLEndpointExchange(serverExchange, httpMethod, requestBodyMediaType, preferredResponseMediaType);
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull GraphQLEndpointExchange exchange) {
        return new SuccessEndpointResponse((Object)this.graphQL.get().getGraphQLSchema());
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message) {
        return (T)((Object)new GraphQLInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createInternalError(@Nonnull String message, @Nonnull Throwable cause) {
        return (T)((Object)new GraphQLInternalError(message, cause));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidUsageException(@Nonnull String message) {
        return (T)((Object)new GraphQLInvalidUsageException(message));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("GET");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        LinkedHashSet mediaTypes = CollectionUtils.createLinkedHashSet((int)1);
        mediaTypes.add("application/graphql");
        return mediaTypes;
    }

    protected void writeResult(@Nonnull GraphQLEndpointExchange exchange, @Nonnull OutputStream outputStream, @Nonnull Object response) {
        Assert.isPremiseValid((boolean)(response instanceof GraphQLSchema), () -> new GraphQLInternalError("Expected response to be instance of GraphQLSchema, but was `" + response.getClass().getName() + "`."));
        String printedSchema = this.schemaPrinter.print((GraphQLSchema)response);
        try (PrintWriter writer = new PrintWriter(outputStream);){
            writer.write(printedSchema);
        }
    }

    protected record GraphQLEndpointExchange(@Nonnull HttpServerExchange serverExchange, @Nonnull String httpMethod, @Nullable String requestBodyContentType, @Nullable String preferredResponseContentType) implements EndpointExchange
    {
    }
}

