/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.externalApi.graphql.GraphQLManager;
import javax.annotation.Nonnull;

public class CatalogGraphQLRefreshingObserver
implements CatalogStructuralChangeObserver {
    private final GraphQLManager graphQLManager;

    public void onCatalogCreate(@Nonnull String catalogName) {
        this.graphQLManager.registerCatalog(catalogName);
    }

    public void onCatalogDelete(@Nonnull String catalogName) {
        this.graphQLManager.unregisterCatalog(catalogName);
    }

    public void onEntityCollectionCreate(@Nonnull String catalogName, @Nonnull String entityType) {
        this.graphQLManager.refreshCatalog(catalogName);
    }

    public void onEntityCollectionDelete(@Nonnull String catalogName, @Nonnull String entityType) {
        this.graphQLManager.refreshCatalog(catalogName);
    }

    public void onCatalogSchemaUpdate(@Nonnull String catalogName) {
        this.graphQLManager.refreshCatalog(catalogName);
    }

    public void onEntitySchemaUpdate(@Nonnull String catalogName, @Nonnull String entityType) {
        this.graphQLManager.refreshCatalog(catalogName);
    }

    public CatalogGraphQLRefreshingObserver(GraphQLManager graphQLManager) {
        this.graphQLManager = graphQLManager;
    }
}

