/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.redis.spring.producer;

import io.eventuate.messaging.redis.spring.common.RedisUtil;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.RedisTemplate;

public class EventuateRedisProducer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, String> redisTemplate;
    private int partitions;

    public EventuateRedisProducer(RedisTemplate<String, String> redisTemplate, int partitions) {
        this.redisTemplate = redisTemplate;
        this.partitions = partitions;
    }

    public CompletableFuture<?> send(String topic, String key, String body) {
        int partition = Math.abs(key.hashCode()) % this.partitions;
        this.logger.info("Sending message = {} with key = {} for topic = {}, partition = {}", new Object[]{body, key, topic, partition});
        this.redisTemplate.opsForStream().add((MapRecord)StreamRecords.string(Collections.singletonMap(key, body)).withStreamKey(RedisUtil.channelToRedisStream((String)topic, (int)partition)));
        this.logger.info("message sent = {} with key = {} for topic = {}, partition = {}", new Object[]{body, key, topic, partition});
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
    }
}

