/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.redis.spring.consumer;

import io.eventuate.messaging.partitionmanagement.GroupMember;
import io.eventuate.messaging.redis.spring.consumer.RedisKeyUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisGroupMember
implements GroupMember {
    private RedisTemplate<String, String> redisTemplate;
    private String memberId;
    private long ttlInMilliseconds;
    private String groupKey;
    private String groupMemberKey;
    private Timer timer = new Timer();

    public RedisGroupMember(RedisTemplate<String, String> redisTemplate, String groupId, String memberId, long ttlInMilliseconds) {
        this.redisTemplate = redisTemplate;
        this.memberId = memberId;
        this.ttlInMilliseconds = ttlInMilliseconds;
        this.groupKey = RedisKeyUtil.keyForMemberGroupSet(groupId);
        this.groupMemberKey = RedisKeyUtil.keyForGroupMember(groupId, memberId);
        this.createOrUpdateGroupMember();
        this.addMemberToGroup();
        this.scheduleGroupMemberTtlRefresh();
    }

    public void remove() {
        this.stopTtlRefreshing();
        this.redisTemplate.opsForSet().remove((Object)this.groupKey, new Object[]{this.memberId});
        this.redisTemplate.delete((Object)this.groupMemberKey);
    }

    void stopTtlRefreshing() {
        this.timer.cancel();
    }

    private void addMemberToGroup() {
        this.redisTemplate.opsForSet().add((Object)this.groupKey, (Object[])new String[]{this.memberId});
    }

    private void scheduleGroupMemberTtlRefresh() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RedisGroupMember.this.createOrUpdateGroupMember();
            }
        }, 0L, this.ttlInMilliseconds / 2L);
    }

    private void createOrUpdateGroupMember() {
        this.redisTemplate.opsForValue().set((Object)this.groupMemberKey, (Object)this.memberId, this.ttlInMilliseconds, TimeUnit.MILLISECONDS);
    }
}

