/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.redis.spring.consumer;

import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.messaging.partitionmanagement.Assignment;
import io.eventuate.messaging.partitionmanagement.AssignmentManager;
import io.eventuate.messaging.redis.spring.consumer.RedisKeyUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisAssignmentManager
implements AssignmentManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, String> redisTemplate;
    private long assignmentTtlInMilliseconds;

    public RedisAssignmentManager(RedisTemplate<String, String> redisTemplate, long assignmentTtlInMilliseconds) {
        this.redisTemplate = redisTemplate;
        this.assignmentTtlInMilliseconds = assignmentTtlInMilliseconds;
    }

    public void initializeAssignment(String groupId, String memberId, Assignment assignment) {
        String assignmentKey = RedisKeyUtil.keyForAssignment(groupId, memberId);
        this.logger.info("Initializing assignment: key = {}, assignment = {}", (Object)assignmentKey, (Object)assignment);
        this.redisTemplate.opsForValue().set((Object)assignmentKey, (Object)JSonMapper.toJson((Object)assignment), this.assignmentTtlInMilliseconds, TimeUnit.MILLISECONDS);
        this.logger.info("Initialized assignment: key = {}, assignment = {}", (Object)assignmentKey, (Object)assignment);
    }

    public Assignment readAssignment(String groupId, String memberId) {
        String assignmentKey = RedisKeyUtil.keyForAssignment(groupId, memberId);
        this.logger.info("Reading assignment: key = {}", (Object)assignmentKey);
        Assignment assignment = (Assignment)JSonMapper.fromJson((String)((String)this.redisTemplate.opsForValue().get((Object)assignmentKey)), Assignment.class);
        this.logger.info("Read assignment: key = {}, assignment = {}", (Object)assignmentKey, (Object)assignment);
        return assignment;
    }

    public void saveAssignment(String groupId, String memberId, Assignment assignment) {
        String assignmentKey = RedisKeyUtil.keyForAssignment(groupId, memberId);
        this.logger.info("Saving assignment: key = {}, assignment = {}", (Object)assignmentKey, (Object)assignment);
        this.redisTemplate.opsForValue().set((Object)assignmentKey, (Object)JSonMapper.toJson((Object)assignment), this.assignmentTtlInMilliseconds, TimeUnit.MILLISECONDS);
        this.logger.info("Saved assignment: key = {}, assignment = {}", (Object)assignmentKey, (Object)assignment);
    }
}

