/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.redis.spring.consumer;

import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.messaging.partitionmanagement.Assignment;
import io.eventuate.messaging.partitionmanagement.AssignmentListener;
import io.eventuate.messaging.redis.spring.consumer.RedisKeyUtil;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisAssignmentListener
implements AssignmentListener {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, String> redisTemplate;
    private Consumer<Assignment> assignmentUpdatedCallback;
    private long assignmentListenerInterval;
    private String assignmentKey;
    private Optional<Assignment> lastAssignment;
    private Timer timer = new Timer();

    public RedisAssignmentListener(RedisTemplate<String, String> redisTemplate, String groupId, String memberId, long assignmentListenerInterval, Consumer<Assignment> assignmentUpdatedCallback) {
        this.redisTemplate = redisTemplate;
        this.assignmentListenerInterval = assignmentListenerInterval;
        this.assignmentUpdatedCallback = assignmentUpdatedCallback;
        this.assignmentKey = RedisKeyUtil.keyForAssignment(groupId, memberId);
        this.lastAssignment = this.readAssignment();
        this.lastAssignment.ifPresent(assignmentUpdatedCallback);
        this.scheduleAssignmentCheck();
    }

    private void scheduleAssignmentCheck() {
        this.logger.info("Scheduling assignment check, key = {}", (Object)this.assignmentKey);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    RedisAssignmentListener.this.checkAssignmentUpdate();
                }
                catch (Exception e) {
                    RedisAssignmentListener.this.logger.error("Assignment check failed, key = {}", (Object)RedisAssignmentListener.this.assignmentKey);
                    RedisAssignmentListener.this.logger.error("Assignment check failed", (Throwable)e);
                }
            }
        }, 0L, this.assignmentListenerInterval);
        this.logger.info("Scheduled assignment check, key = {}", (Object)this.assignmentKey);
    }

    private void checkAssignmentUpdate() {
        Optional<Assignment> currentAssignment = this.readAssignment();
        if (!currentAssignment.equals(this.lastAssignment)) {
            currentAssignment.ifPresent(this.assignmentUpdatedCallback);
            this.lastAssignment = currentAssignment;
        }
    }

    private Optional<Assignment> readAssignment() {
        return Optional.ofNullable(this.redisTemplate.opsForValue().get((Object)this.assignmentKey)).map(jsonAssignment -> (Assignment)JSonMapper.fromJson((String)jsonAssignment, Assignment.class));
    }

    public void remove() {
        this.logger.info("Removing assignment check, key = {}", (Object)this.assignmentKey);
        this.timer.cancel();
        this.logger.info("Removed assignment check, key = {}", (Object)this.assignmentKey);
    }
}

