/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.redis.spring.consumer;

import io.eventuate.messaging.partitionmanagement.CommonMessageConsumer;
import io.eventuate.messaging.partitionmanagement.CoordinatorFactory;
import io.eventuate.messaging.partitionmanagement.SubscriptionLeaderHook;
import io.eventuate.messaging.partitionmanagement.SubscriptionLifecycleHook;
import io.eventuate.messaging.redis.spring.consumer.RedisMessageHandler;
import io.eventuate.messaging.redis.spring.consumer.Subscription;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class MessageConsumerRedisImpl
implements CommonMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public final String consumerId;
    private Supplier<String> subscriptionIdSupplier;
    private RedisTemplate<String, String> redisTemplate;
    private ConcurrentLinkedQueue<Subscription> subscriptions = new ConcurrentLinkedQueue();
    private final CoordinatorFactory coordinatorFactory;
    private long timeInMillisecondsToSleepWhenKeyDoesNotExist;
    private long blockStreamTimeInMilliseconds;

    public MessageConsumerRedisImpl(RedisTemplate<String, String> redisTemplate, CoordinatorFactory coordinatorFactory, long timeInMillisecondsToSleepWhenKeyDoesNotExist, long blockStreamTimeInMilliseconds) {
        this(() -> UUID.randomUUID().toString(), UUID.randomUUID().toString(), redisTemplate, coordinatorFactory, timeInMillisecondsToSleepWhenKeyDoesNotExist, blockStreamTimeInMilliseconds);
    }

    public MessageConsumerRedisImpl(Supplier<String> subscriptionIdSupplier, String consumerId, RedisTemplate<String, String> redisTemplate, CoordinatorFactory coordinatorFactory, long timeInMillisecondsToSleepWhenKeyDoesNotExist, long blockStreamTimeInMilliseconds) {
        this.subscriptionIdSupplier = subscriptionIdSupplier;
        this.consumerId = consumerId;
        this.redisTemplate = redisTemplate;
        this.coordinatorFactory = coordinatorFactory;
        this.timeInMillisecondsToSleepWhenKeyDoesNotExist = timeInMillisecondsToSleepWhenKeyDoesNotExist;
        this.blockStreamTimeInMilliseconds = blockStreamTimeInMilliseconds;
        this.logger.info("Consumer created (consumer id = {})", (Object)consumerId);
    }

    public Subscription subscribe(String subscriberId, Set<String> channels, RedisMessageHandler handler) {
        this.logger.info("Consumer subscribes to channels (consumer id = {}, subscriber id {}, channels = {})", new Object[]{this.consumerId, subscriberId, channels});
        Subscription subscription = new Subscription(this.subscriptionIdSupplier.get(), this.consumerId, this.redisTemplate, subscriberId, channels, handler, this.coordinatorFactory, this.timeInMillisecondsToSleepWhenKeyDoesNotExist, this.blockStreamTimeInMilliseconds);
        this.subscriptions.add(subscription);
        subscription.setClosingCallback(() -> this.subscriptions.remove(subscription));
        this.logger.info("Consumer subscribed to channels (consumer id = {}, subscriber id {}, channels = {})", new Object[]{this.consumerId, subscriberId, channels});
        return subscription;
    }

    public void setSubscriptionLifecycleHook(SubscriptionLifecycleHook subscriptionLifecycleHook) {
        this.subscriptions.forEach(subscription -> subscription.setSubscriptionLifecycleHook(subscriptionLifecycleHook));
    }

    public void setLeaderHook(SubscriptionLeaderHook leaderHook) {
        this.subscriptions.forEach(subscription -> subscription.setLeaderHook(leaderHook));
    }

    public void close() {
        this.logger.info("Closing consumer (consumer id = {})", (Object)this.consumerId);
        this.subscriptions.forEach(Subscription::close);
        this.subscriptions.clear();
        this.logger.info("Closed consumer (consumer id = {})", (Object)this.consumerId);
    }

    public String getId() {
        return this.consumerId;
    }
}

